/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import javax.annotation.Nullable;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksObjectUtils;
import org.rocksdb.RocksObject;

class ManagedObject<T extends RocksObject>
implements AutoCloseable {
    private final T original;
    @Nullable
    private final StackTraceElement[] elements;

    ManagedObject(T original) {
        this.original = original;
        this.elements = ManagedRocksObjectUtils.getStackTrace();
    }

    public T get() {
        return this.original;
    }

    @Override
    public void close() {
        this.original.close();
    }

    protected void finalize() throws Throwable {
        ManagedRocksObjectUtils.assertClosed(this);
        super.finalize();
    }

    public String getStackTrace() {
        return ManagedRocksObjectUtils.formatStackTrace(this.elements);
    }
}

