/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.utils.db.managed.ManagedObject;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksObjectMetrics;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManagedRocksObjectUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ManagedRocksObjectUtils.class);
    private static final Duration POLL_DELAY_DURATION = Duration.ZERO;
    private static final Duration POLL_INTERVAL_DURATION = Duration.ofMillis(100L);

    private ManagedRocksObjectUtils() {
    }

    public static void assertClosed(ManagedObject<?> object) {
        ManagedRocksObjectUtils.assertClosed(object.get(), object.getStackTrace());
    }

    static void assertClosed(RocksObject rocksObject, String stackTrace) {
        ManagedRocksObjectMetrics.INSTANCE.increaseManagedObject();
        if (rocksObject.isOwningHandle()) {
            ManagedRocksObjectUtils.reportLeak(rocksObject, stackTrace);
        }
    }

    static void reportLeak(Object object, String stackTrace) {
        ManagedRocksObjectMetrics.INSTANCE.increaseLeakObject();
        String warning = String.format("%s is not closed properly", object.getClass().getSimpleName());
        if (stackTrace != null && LOG.isDebugEnabled()) {
            String debugMessage = String.format("%nStackTrace for unclosed instance: %s", stackTrace);
            warning = warning.concat(debugMessage);
        }
        LOG.warn(warning);
    }

    @Nullable
    static StackTraceElement[] getStackTrace() {
        return HddsUtils.getStackTrace((Logger)LOG);
    }

    static String formatStackTrace(@Nullable StackTraceElement[] elements) {
        return HddsUtils.formatStackTrace((StackTraceElement[])elements, (int)3);
    }

    public static void waitForFileDelete(File file, Duration maxDuration, Duration interval, Duration pollDelayDuration) throws IOException {
        Instant start = Instant.now();
        try {
            Awaitility.with().atMost(maxDuration).pollDelay(pollDelayDuration).pollInterval(interval).await().until(() -> !file.exists());
            LOG.info("Waited for {} milliseconds for file {} deletion.", (Object)Duration.between(start, Instant.now()).toMillis(), (Object)file.getAbsoluteFile());
        }
        catch (ConditionTimeoutException exception) {
            LOG.info("File: {} didn't get deleted in {} secs.", (Object)file.getAbsolutePath(), (Object)maxDuration.getSeconds());
            throw new IOException(exception);
        }
    }

    public static void waitForFileDelete(File file, Duration maxDuration) throws IOException {
        ManagedRocksObjectUtils.waitForFileDelete(file, maxDuration, POLL_INTERVAL_DURATION, POLL_DELAY_DURATION);
    }

    public static void loadRocksDBLibrary() {
        RocksDB.loadLibrary();
    }
}

