/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import com.google.common.collect.Maps;
import com.google.common.primitives.UnsignedLong;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.utils.db.managed.ManagedOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSSTDumpTool;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSlice;
import org.apache.hadoop.util.ClosableIterator;
import org.eclipse.jetty.io.RuntimeIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManagedSSTDumpIterator<T>
implements ClosableIterator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedSSTDumpIterator.class);
    private InputStream processOutput;
    private Optional<KeyValue> currentKey;
    private byte[] intBuffer;
    private Optional<KeyValue> nextKey;
    private ManagedSSTDumpTool.SSTDumpToolTask sstDumpToolTask;
    private AtomicBoolean open;
    private StackTraceElement[] stackTrace;

    public ManagedSSTDumpIterator(ManagedSSTDumpTool sstDumpTool, String sstFilePath, ManagedOptions options) throws IOException {
        this(sstDumpTool, sstFilePath, options, null, null);
    }

    public ManagedSSTDumpIterator(ManagedSSTDumpTool sstDumpTool, String sstFilePath, ManagedOptions options, ManagedSlice lowerKeyBound, ManagedSlice upperKeyBound) throws IOException {
        File sstFile = new File(sstFilePath);
        if (!sstFile.exists()) {
            throw new IOException(String.format("File in path : %s doesn't exist", sstFile.getAbsolutePath()));
        }
        if (!sstFile.isFile()) {
            throw new IOException(String.format("Path given: %s is not a file", sstFile.getAbsolutePath()));
        }
        this.init(sstDumpTool, sstFile, options, lowerKeyBound, upperKeyBound);
        this.stackTrace = Thread.currentThread().getStackTrace();
    }

    private Optional<Integer> getNextNumberInStream() throws IOException {
        int n = this.processOutput.read(this.intBuffer, 0, 4);
        if (n == 4) {
            return Optional.of(ByteBuffer.wrap(this.intBuffer).getInt());
        }
        if (n >= 0) {
            throw new IllegalStateException(String.format("Integer expects 4 bytes to be read from the stream, but read only %d bytes", n));
        }
        return Optional.empty();
    }

    private Optional<byte[]> getNextByteArray() throws IOException {
        Optional<Integer> size = this.getNextNumberInStream();
        if (size.isPresent()) {
            byte[] b;
            int n;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Allocating byte array, size: {}", (Object)size.get());
            }
            if ((n = this.processOutput.read(b = new byte[size.get().intValue()])) >= 0 && n != size.get()) {
                throw new IllegalStateException(String.format("Integer expects 4 bytes to be read from the stream, but read only %d bytes", n));
            }
            return Optional.of(b);
        }
        return Optional.empty();
    }

    private Optional<UnsignedLong> getNextUnsignedLong() throws IOException {
        long val = 0L;
        for (int i = 0; i < 8; ++i) {
            val <<= 8;
            int nextByte = this.processOutput.read();
            if (nextByte < 0) {
                if (i == 0) {
                    return Optional.empty();
                }
                throw new IllegalStateException(String.format("Long expects 8 bytes to be read from the stream, but read only %d bytes", i));
            }
            val += (long)nextByte;
        }
        return Optional.of(UnsignedLong.fromLongBits((long)val));
    }

    private void init(ManagedSSTDumpTool sstDumpTool, File sstFile, ManagedOptions options, ManagedSlice lowerKeyBound, ManagedSlice upperKeyBound) {
        HashMap argMap = Maps.newHashMap();
        argMap.put("file", sstFile.getAbsolutePath());
        argMap.put("silent", null);
        argMap.put("command", "scan");
        if (Objects.nonNull(lowerKeyBound)) {
            argMap.put("from", String.valueOf(lowerKeyBound.getNativeHandle()));
        }
        if (Objects.nonNull(upperKeyBound)) {
            argMap.put("to", String.valueOf(upperKeyBound.getNativeHandle()));
        }
        this.sstDumpToolTask = sstDumpTool.run(argMap, options);
        this.processOutput = this.sstDumpToolTask.getPipedOutput();
        this.intBuffer = new byte[4];
        this.open = new AtomicBoolean(true);
        this.currentKey = Optional.empty();
        this.nextKey = Optional.empty();
        this.next();
    }

    private void checkSanityOfProcess() {
        if (!this.open.get()) {
            throw new RuntimeException("Iterator has been closed");
        }
        if (this.sstDumpToolTask.getFuture().isDone() && this.sstDumpToolTask.exitValue() != 0) {
            throw new RuntimeException("Process Terminated with non zero " + String.format("exit value %d", this.sstDumpToolTask.exitValue()));
        }
    }

    public boolean hasNext() {
        this.checkSanityOfProcess();
        return this.nextKey.isPresent();
    }

    protected abstract T getTransformedValue(Optional<KeyValue> var1);

    public T next() {
        this.checkSanityOfProcess();
        this.currentKey = this.nextKey;
        this.nextKey = Optional.empty();
        try {
            Optional<byte[]> key = this.getNextByteArray();
            if (!key.isPresent()) {
                return this.getTransformedValue(this.currentKey);
            }
            UnsignedLong sequenceNumber = this.getNextUnsignedLong().orElseThrow(() -> new IllegalStateException(String.format("Error while trying to read sequence number for key %s", StringUtils.bytes2String((byte[])((byte[])key.get())))));
            Integer type = this.getNextNumberInStream().orElseThrow(() -> new IllegalStateException(String.format("Error while trying to read sequence number for key %s with sequence number %s", StringUtils.bytes2String((byte[])((byte[])key.get())), sequenceNumber.toString())));
            byte[] val = this.getNextByteArray().orElseThrow(() -> new IllegalStateException(String.format("Error while trying to read sequence number for key %s with sequence number %s of type %d", StringUtils.bytes2String((byte[])((byte[])key.get())), sequenceNumber.toString(), type)));
            this.nextKey = Optional.of(new KeyValue(key.get(), sequenceNumber, type, val));
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        return this.getTransformedValue(this.currentKey);
    }

    public synchronized void close() throws UncheckedIOException {
        if (this.sstDumpToolTask != null) {
            if (!this.sstDumpToolTask.getFuture().isDone()) {
                this.sstDumpToolTask.getFuture().cancel(true);
            }
            try {
                this.processOutput.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.open.compareAndSet(true, false);
    }

    protected void finalize() throws Throwable {
        if (this.open.get()) {
            LOG.warn("{}  is not closed properly. StackTrace for unclosed instance: {}", (Object)this.getClass().getName(), (Object)Arrays.stream(this.stackTrace).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
        }
        this.close();
        super.finalize();
    }

    public static final class KeyValue {
        private final byte[] key;
        private final UnsignedLong sequence;
        private final Integer type;
        private final byte[] value;

        private KeyValue(byte[] key, UnsignedLong sequence, Integer type, byte[] value) {
            this.key = key;
            this.sequence = sequence;
            this.type = type;
            this.value = value;
        }

        public byte[] getKey() {
            return this.key;
        }

        public UnsignedLong getSequence() {
            return this.sequence;
        }

        public Integer getType() {
            return this.type;
        }

        public byte[] getValue() {
            return this.value;
        }

        public String toString() {
            return "KeyValue{key=" + StringUtils.bytes2String((byte[])this.key) + ", sequence=" + this.sequence + ", type=" + this.type + ", value=" + StringUtils.bytes2String((byte[])this.value) + '}';
        }
    }
}

