/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.hdds.utils.NativeLibraryLoader;
import org.apache.hadoop.hdds.utils.NativeLibraryNotLoadedException;
import org.apache.hadoop.hdds.utils.db.managed.ManagedOptions;
import org.apache.hadoop.hdds.utils.db.managed.PipeInputStream;

public class ManagedSSTDumpTool {
    private int bufferCapacity;
    private ExecutorService executorService;

    public ManagedSSTDumpTool(ExecutorService executorService, int bufferCapacity) throws NativeLibraryNotLoadedException {
        if (!NativeLibraryLoader.getInstance().loadLibrary("ozone_rocksdb_tools")) {
            throw new NativeLibraryNotLoadedException("ozone_rocksdb_tools");
        }
        this.bufferCapacity = bufferCapacity;
        this.executorService = executorService;
    }

    public SSTDumpToolTask run(String[] args, ManagedOptions options) {
        PipeInputStream pipeInputStream = new PipeInputStream(this.bufferCapacity);
        return new SSTDumpToolTask(this.executorService.submit(() -> this.runInternal(args, options.getNativeHandle(), pipeInputStream.getNativeHandle())), pipeInputStream);
    }

    public SSTDumpToolTask run(Map<String, String> args, ManagedOptions options) {
        return this.run((String[])args.entrySet().stream().map(e -> "--" + (e.getValue() == null || ((String)e.getValue()).isEmpty() ? (String)e.getKey() : (String)e.getKey() + "=" + (String)e.getValue())).toArray(String[]::new), options);
    }

    private native int runInternal(String[] var1, long var2, long var4);

    static class SSTDumpToolTask {
        private Future<Integer> future;
        private InputStream pipedOutput;

        SSTDumpToolTask(Future<Integer> future, InputStream pipedOutput) {
            this.future = future;
            this.pipedOutput = pipedOutput;
        }

        public Future<Integer> getFuture() {
            return this.future;
        }

        public InputStream getPipedOutput() {
            return this.pipedOutput;
        }

        public int exitValue() {
            if (this.future.isDone()) {
                try {
                    return this.future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    return 1;
                }
            }
            return 0;
        }
    }
}

