/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class PipeInputStream
extends InputStream {
    private byte[] byteBuffer;
    private long nativeHandle;
    private int numberOfBytesLeftToRead;
    private int index = 0;
    private int capacity;
    private AtomicBoolean cleanup;

    PipeInputStream(int capacity) {
        this.byteBuffer = new byte[capacity];
        this.numberOfBytesLeftToRead = 0;
        this.capacity = capacity;
        this.nativeHandle = this.newPipe();
        this.cleanup = new AtomicBoolean(false);
    }

    long getNativeHandle() {
        return this.nativeHandle;
    }

    @Override
    public int read() {
        if (this.numberOfBytesLeftToRead < 0) {
            this.close();
            return -1;
        }
        while (this.numberOfBytesLeftToRead == 0) {
            this.numberOfBytesLeftToRead = this.readInternal(this.byteBuffer, this.capacity, this.nativeHandle);
            this.index = 0;
            if (this.numberOfBytesLeftToRead == 0) continue;
            return this.read();
        }
        --this.numberOfBytesLeftToRead;
        int ret = this.byteBuffer[this.index] & 0xFF;
        ++this.index;
        return ret;
    }

    private native long newPipe();

    private native int readInternal(byte[] var1, int var2, long var3);

    private native void closeInternal(long var1);

    @Override
    public void close() {
        if (this.cleanup.compareAndSet(false, true)) {
            this.closeInternal(this.nativeHandle);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

