/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.keys;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.ssl.KeyStoresFactory;
import org.apache.hadoop.hdds.security.ssl.PemFileBasedKeyStoresFactory;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.exception.CertificateException;

public final class SecurityUtil {
    private SecurityUtil() {
    }

    public static PrivateKey getPrivateKey(byte[] encodedKey, SecurityConfig secureConfig) {
        PrivateKey pvtKey = null;
        if (encodedKey == null || encodedKey.length == 0) {
            return null;
        }
        try {
            KeyFactory kf = null;
            kf = KeyFactory.getInstance(secureConfig.getKeyAlgo(), secureConfig.getProvider());
            pvtKey = kf.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            return null;
        }
        return pvtKey;
    }

    public static PublicKey getPublicKey(byte[] encodedKey, SecurityConfig secureConfig) {
        PublicKey key = null;
        if (encodedKey == null || encodedKey.length == 0) {
            return null;
        }
        try {
            KeyFactory kf = null;
            kf = KeyFactory.getInstance(secureConfig.getKeyAlgo(), secureConfig.getProvider());
            key = kf.generatePublic(new X509EncodedKeySpec(encodedKey));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            return null;
        }
        return key;
    }

    public static KeyStoresFactory getServerKeyStoresFactory(SecurityConfig securityConfig, CertificateClient client, boolean requireClientAuth) throws CertificateException {
        PemFileBasedKeyStoresFactory factory = new PemFileBasedKeyStoresFactory(securityConfig, client);
        try {
            factory.init(KeyStoresFactory.Mode.SERVER, requireClientAuth);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new CertificateException("Failed to init keyStoresFactory", (Throwable)e, CertificateException.ErrorCode.KEYSTORE_ERROR);
        }
        return factory;
    }

    public static KeyStoresFactory getClientKeyStoresFactory(SecurityConfig securityConfig, CertificateClient client, boolean requireClientAuth) throws CertificateException {
        PemFileBasedKeyStoresFactory factory = new PemFileBasedKeyStoresFactory(securityConfig, client);
        try {
            factory.init(KeyStoresFactory.Mode.CLIENT, requireClientAuth);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new CertificateException("Failed to init keyStoresFactory", (Throwable)e, CertificateException.ErrorCode.KEYSTORE_ERROR);
        }
        return factory;
    }
}

