/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.TableCacheMetrics;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;

@InterfaceStability.Evolving
public interface Table<KEY, VALUE>
extends AutoCloseable {
    public void put(KEY var1, VALUE var2) throws IOException;

    public void putWithBatch(BatchOperation var1, KEY var2, VALUE var3) throws IOException;

    public boolean isEmpty() throws IOException;

    public boolean isExist(KEY var1) throws IOException;

    public VALUE get(KEY var1) throws IOException;

    default public VALUE getSkipCache(KEY key) throws IOException {
        throw new NotImplementedException("getSkipCache is not implemented");
    }

    default public VALUE getReadCopy(KEY key) throws IOException {
        throw new NotImplementedException("getReadCopy is not implemented");
    }

    public VALUE getIfExist(KEY var1) throws IOException;

    public void delete(KEY var1) throws IOException;

    public void deleteWithBatch(BatchOperation var1, KEY var2) throws IOException;

    public void deleteRange(KEY var1, KEY var2) throws IOException;

    public TableIterator<KEY, ? extends KeyValue<KEY, VALUE>> iterator() throws IOException;

    public TableIterator<KEY, ? extends KeyValue<KEY, VALUE>> iterator(KEY var1) throws IOException;

    public String getName() throws IOException;

    public long getEstimatedKeyCount() throws IOException;

    default public void addCacheEntry(CacheKey<KEY> cacheKey, CacheValue<VALUE> cacheValue) {
        throw new NotImplementedException("addCacheEntry is not implemented");
    }

    default public void addCacheEntry(KEY cacheKey, long epoch) {
        this.addCacheEntry(new CacheKey<KEY>(cacheKey), CacheValue.get(epoch));
    }

    default public void addCacheEntry(KEY cacheKey, VALUE value, long epoch) {
        this.addCacheEntry(new CacheKey<KEY>(cacheKey), CacheValue.get(epoch, value));
    }

    default public CacheValue<VALUE> getCacheValue(CacheKey<KEY> cacheKey) {
        throw new NotImplementedException("getCacheValue is not implemented");
    }

    default public void cleanupCache(List<Long> epochs) {
        throw new NotImplementedException("cleanupCache is not implemented");
    }

    default public Iterator<Map.Entry<CacheKey<KEY>, CacheValue<VALUE>>> cacheIterator() {
        throw new NotImplementedException("cacheIterator is not implemented");
    }

    default public TableCacheMetrics createCacheMetrics() throws IOException {
        throw new NotImplementedException("getCacheValue is not implemented");
    }

    public List<? extends KeyValue<KEY, VALUE>> getRangeKVs(KEY var1, int var2, KEY var3, MetadataKeyFilters.MetadataKeyFilter ... var4) throws IOException, IllegalArgumentException;

    public List<? extends KeyValue<KEY, VALUE>> getSequentialRangeKVs(KEY var1, int var2, KEY var3, MetadataKeyFilters.MetadataKeyFilter ... var4) throws IOException, IllegalArgumentException;

    public void deleteBatchWithPrefix(BatchOperation var1, KEY var2) throws IOException;

    public void dumpToFileWithPrefix(File var1, KEY var2) throws IOException;

    public void loadFromFile(File var1) throws IOException;

    public static <K, V> KeyValue<K, V> newKeyValue(final K key, final V value) {
        return new KeyValue<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            public String toString() {
                return "(key=" + key + ", value=" + value + ")";
            }
        };
    }

    public static interface KeyValueIterator<KEY, VALUE>
    extends TableIterator<KEY, KeyValue<KEY, VALUE>> {
    }

    public static interface KeyValue<KEY, VALUE> {
        public KEY getKey() throws IOException;

        public VALUE getValue() throws IOException;
    }
}

