/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheResult;
import org.apache.hadoop.hdds.utils.db.cache.CacheStats;
import org.apache.hadoop.hdds.utils.db.cache.CacheStatsRecorder;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.hdds.utils.db.cache.TableCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FullTableCache<KEY, VALUE>
implements TableCache<KEY, VALUE> {
    public static final Logger LOG = LoggerFactory.getLogger(FullTableCache.class);
    private final Map<CacheKey<KEY>, CacheValue<VALUE>> cache = new ConcurrentSkipListMap<CacheKey<KEY>, CacheValue<VALUE>>();
    private final NavigableMap<Long, Set<CacheKey<KEY>>> epochEntries;
    private final ExecutorService executorService;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final CacheStatsRecorder statsRecorder;

    public FullTableCache(String threadNamePrefix) {
        this.epochEntries = new ConcurrentSkipListMap<Long, Set<CacheKey<KEY>>>();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadNamePrefix + "FullTableCache-Cleanup-%d").build();
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.statsRecorder = new CacheStatsRecorder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheValue<VALUE> get(CacheKey<KEY> cachekey) {
        try {
            this.lock.readLock().lock();
            CacheValue<VALUE> cachevalue = this.cache.get(cachekey);
            this.statsRecorder.recordValue(cachevalue);
            CacheValue<VALUE> cacheValue = cachevalue;
            return cacheValue;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void loadInitial(CacheKey<KEY> key, CacheValue<VALUE> value) {
        this.cache.put(key, value);
    }

    @Override
    public void put(CacheKey<KEY> cacheKey, CacheValue<VALUE> value) {
        try {
            this.lock.writeLock().lock();
            this.cache.put(cacheKey, value);
            this.epochEntries.computeIfAbsent(value.getEpoch(), v -> new CopyOnWriteArraySet()).add(cacheKey);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void cleanup(List<Long> epochs) {
        this.executorService.execute(() -> this.evictCache(epochs));
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Iterator<Map.Entry<CacheKey<KEY>, CacheValue<VALUE>>> iterator() {
        this.statsRecorder.recordIteration();
        return this.cache.entrySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void evictCache(List<Long> epochs) {
        long lastEpoch = epochs.get(epochs.size() - 1);
        Iterator iterator = this.epochEntries.keySet().iterator();
        while (iterator.hasNext()) {
            long currentEpoch = (Long)iterator.next();
            Set currentCacheKeys = (Set)this.epochEntries.get(currentEpoch);
            if (currentEpoch > lastEpoch) break;
            try {
                this.lock.writeLock().lock();
                if (!epochs.contains(currentEpoch)) continue;
                for (CacheKey cachekey : currentCacheKeys) {
                    this.cache.computeIfPresent(cachekey, (k, v) -> {
                        if (v.getCacheValue() == null && v.getEpoch() == currentEpoch) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("CacheKey {} with epoch {} is removed from cache", k.getCacheKey(), (Object)currentEpoch);
                            }
                            return null;
                        }
                        return v;
                    });
                }
                this.epochEntries.remove(currentEpoch);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public CacheResult<VALUE> lookup(CacheKey<KEY> cachekey) {
        CacheValue<VALUE> cachevalue = this.cache.get(cachekey);
        this.statsRecorder.recordValue(cachevalue);
        if (cachevalue == null) {
            return new CacheResult(CacheResult.CacheStatus.NOT_EXIST, null);
        }
        if (cachevalue.getCacheValue() != null) {
            return new CacheResult<VALUE>(CacheResult.CacheStatus.EXISTS, cachevalue);
        }
        return new CacheResult(CacheResult.CacheStatus.NOT_EXIST, null);
    }

    @Override
    @VisibleForTesting
    public NavigableMap<Long, Set<CacheKey<KEY>>> getEpochEntries() {
        return this.epochEntries;
    }

    @Override
    public CacheStats getStats() {
        return this.statsRecorder.snapshot();
    }

    @Override
    public TableCache.CacheType getCacheType() {
        return TableCache.CacheType.FULL_CACHE;
    }
}

