/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmConfig;
import org.apache.hadoop.hdds.scm.container.AbstractContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.container.report.ContainerReportValidator;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerReportHandler
extends AbstractContainerReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerReportHandler.class);
    private final NodeManager nodeManager;
    private final ContainerManager containerManager;
    private final String unknownContainerHandleAction;
    static final String UNKNOWN_CONTAINER_ACTION_WARN = "WARN";
    static final String UNKNOWN_CONTAINER_ACTION_DELETE = "DELETE";

    public ContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager, SCMContext scmContext, OzoneConfiguration conf) {
        super(containerManager, scmContext, LOG);
        this.nodeManager = nodeManager;
        this.containerManager = containerManager;
        if (conf != null) {
            ScmConfig scmConfig = (ScmConfig)conf.getObject(ScmConfig.class);
            this.unknownContainerHandleAction = scmConfig.getUnknownContainerAction();
        } else {
            this.unknownContainerHandleAction = UNKNOWN_CONTAINER_ACTION_WARN;
        }
    }

    public ContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager) {
        this(nodeManager, containerManager, SCMContext.emptyContext(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode reportFromDatanode, EventPublisher publisher) {
        DatanodeDetails dnFromReport = reportFromDatanode.getDatanodeDetails();
        DatanodeDetails datanodeDetails = this.nodeManager.getNodeByUuid(dnFromReport.getUuid());
        if (datanodeDetails == null) {
            LOG.warn("Received container report from unknown datanode {}", (Object)dnFromReport);
            return;
        }
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = (StorageContainerDatanodeProtocolProtos.ContainerReportsProto)reportFromDatanode.getReport();
        try {
            DatanodeDetails datanodeDetails2 = datanodeDetails;
            synchronized (datanodeDetails2) {
                List replicas = containerReport.getReportsList();
                Set<ContainerID> expectedContainersInDatanode = this.nodeManager.getContainers(datanodeDetails);
                for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replica : replicas) {
                    ContainerID cid = ContainerID.valueOf((long)replica.getContainerID());
                    ContainerInfo container = null;
                    try {
                        container = this.containerManager.getContainer(cid);
                        cid = container.containerID();
                    }
                    catch (ContainerNotFoundException containerNotFoundException) {
                        // empty catch block
                    }
                    boolean alreadyInDn = expectedContainersInDatanode.remove(cid);
                    if (!alreadyInDn) {
                        this.nodeManager.addContainer(datanodeDetails, cid);
                    }
                    if (container != null && !ContainerReportValidator.validate(container, datanodeDetails, replica)) continue;
                    this.processSingleReplica(datanodeDetails, container, replica, publisher);
                }
                this.processMissingReplicas(datanodeDetails, expectedContainersInDatanode);
                this.containerManager.notifyContainerReportProcessing(true, true);
            }
        }
        catch (NodeNotFoundException ex) {
            this.containerManager.notifyContainerReportProcessing(true, false);
            LOG.error("Received container report from unknown datanode {}.", (Object)datanodeDetails, (Object)ex);
        }
    }

    private void processSingleReplica(DatanodeDetails datanodeDetails, ContainerInfo container, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto, EventPublisher publisher) {
        if (container == null) {
            if (this.unknownContainerHandleAction.equals(UNKNOWN_CONTAINER_ACTION_WARN)) {
                LOG.error("Received container report for an unknown container {} from datanode {}.", (Object)replicaProto.getContainerID(), (Object)datanodeDetails);
            } else if (this.unknownContainerHandleAction.equals(UNKNOWN_CONTAINER_ACTION_DELETE)) {
                ContainerID containerId = ContainerID.valueOf((long)replicaProto.getContainerID());
                this.deleteReplica(containerId, datanodeDetails, publisher, "unknown");
            }
            return;
        }
        try {
            this.processContainerReplica(datanodeDetails, container, replicaProto, publisher);
        }
        catch (IOException | TimeoutException | InvalidStateTransitionException e) {
            LOG.error("Exception while processing container report for container {} from datanode {}.", new Object[]{replicaProto.getContainerID(), datanodeDetails, e});
        }
    }

    private void processMissingReplicas(DatanodeDetails datanodeDetails, Set<ContainerID> missingReplicas) {
        for (ContainerID id : missingReplicas) {
            try {
                this.nodeManager.removeContainer(datanodeDetails, id);
            }
            catch (NodeNotFoundException e) {
                LOG.warn("Failed to remove container {} from a node which does not exist {}", new Object[]{id, datanodeDetails, e});
            }
            try {
                this.containerManager.getContainerReplicas(id).stream().filter(replica -> replica.getDatanodeDetails().equals((Object)datanodeDetails)).findFirst().ifPresent(replica -> {
                    try {
                        this.containerManager.removeContainerReplica(id, (ContainerReplica)replica);
                    }
                    catch (ContainerNotFoundException | ContainerReplicaNotFoundException throwable) {
                        // empty catch block
                    }
                });
            }
            catch (ContainerNotFoundException e) {
                LOG.warn("Cannot remove container replica, container {} not found.", (Object)id, (Object)e);
            }
        }
    }
}

