/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Striped;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerStateManager;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaPendingOps;
import org.apache.hadoop.hdds.scm.container.states.ContainerState;
import org.apache.hadoop.hdds.scm.container.states.ContainerStateMap;
import org.apache.hadoop.hdds.scm.ha.ExecutionUtil;
import org.apache.hadoop.hdds.scm.ha.SCMHAInvocationHandler;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.metadata.DBTransactionBuffer;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.apache.hadoop.ozone.common.statemachine.StateMachine;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerStateManagerImpl
implements ContainerStateManager {
    private final Striped<ReadWriteLock> stripedLock;
    private static final Logger LOG = LoggerFactory.getLogger(ContainerStateManagerImpl.class);
    private final long containerSize;
    private ContainerStateMap containers;
    private Table<ContainerID, ContainerInfo> containerStore;
    private final DBTransactionBuffer transactionBuffer;
    private final PipelineManager pipelineManager;
    private final StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent> stateMachine;
    private final ContainerReplicaPendingOps containerReplicaPendingOps;
    private ConcurrentHashMap<ContainerState, ContainerID> lastUsedMap;
    private final Map<HddsProtos.LifeCycleEvent, CheckedConsumer<ContainerInfo, IOException>> containerStateChangeActions;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    private ContainerStateManagerImpl(Configuration conf, PipelineManager pipelineManager, Table<ContainerID, ContainerInfo> containerStore, DBTransactionBuffer buffer, ContainerReplicaPendingOps pendingOps) throws IOException {
        this.pipelineManager = pipelineManager;
        this.containerStore = containerStore;
        this.stateMachine = this.newStateMachine();
        this.containerSize = this.getConfiguredContainerSize(conf);
        this.containers = new ContainerStateMap();
        this.lastUsedMap = new ConcurrentHashMap();
        this.containerStateChangeActions = this.getContainerStateChangeActions();
        this.transactionBuffer = buffer;
        this.stripedLock = Striped.readWriteLock((int)conf.getInt("ozone.scm.container.lock.stripes", 512));
        this.containerReplicaPendingOps = pendingOps;
        this.initialize();
    }

    private StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent> newStateMachine() {
        HashSet<HddsProtos.LifeCycleState> finalStates = new HashSet<HddsProtos.LifeCycleState>();
        finalStates.add(HddsProtos.LifeCycleState.CLOSED);
        finalStates.add(HddsProtos.LifeCycleState.DELETED);
        StateMachine containerLifecycleSM = new StateMachine((Enum)HddsProtos.LifeCycleState.OPEN, finalStates);
        containerLifecycleSM.addTransition((Enum)HddsProtos.LifeCycleState.OPEN, (Enum)HddsProtos.LifeCycleState.CLOSING, (Enum)HddsProtos.LifeCycleEvent.FINALIZE);
        containerLifecycleSM.addTransition((Enum)HddsProtos.LifeCycleState.CLOSING, (Enum)HddsProtos.LifeCycleState.QUASI_CLOSED, (Enum)HddsProtos.LifeCycleEvent.QUASI_CLOSE);
        containerLifecycleSM.addTransition((Enum)HddsProtos.LifeCycleState.CLOSING, (Enum)HddsProtos.LifeCycleState.CLOSED, (Enum)HddsProtos.LifeCycleEvent.CLOSE);
        containerLifecycleSM.addTransition((Enum)HddsProtos.LifeCycleState.QUASI_CLOSED, (Enum)HddsProtos.LifeCycleState.CLOSED, (Enum)HddsProtos.LifeCycleEvent.FORCE_CLOSE);
        containerLifecycleSM.addTransition((Enum)HddsProtos.LifeCycleState.CLOSED, (Enum)HddsProtos.LifeCycleState.DELETING, (Enum)HddsProtos.LifeCycleEvent.DELETE);
        containerLifecycleSM.addTransition((Enum)HddsProtos.LifeCycleState.DELETING, (Enum)HddsProtos.LifeCycleState.DELETED, (Enum)HddsProtos.LifeCycleEvent.CLEANUP);
        this.makeStateTransitionIdempotent((StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent>)containerLifecycleSM, HddsProtos.LifeCycleEvent.FINALIZE, HddsProtos.LifeCycleState.CLOSING, HddsProtos.LifeCycleState.QUASI_CLOSED, HddsProtos.LifeCycleState.CLOSED, HddsProtos.LifeCycleState.DELETING, HddsProtos.LifeCycleState.DELETED);
        this.makeStateTransitionIdempotent((StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent>)containerLifecycleSM, HddsProtos.LifeCycleEvent.QUASI_CLOSE, HddsProtos.LifeCycleState.QUASI_CLOSED, HddsProtos.LifeCycleState.CLOSED, HddsProtos.LifeCycleState.DELETING, HddsProtos.LifeCycleState.DELETED);
        this.makeStateTransitionIdempotent((StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent>)containerLifecycleSM, HddsProtos.LifeCycleEvent.CLOSE, HddsProtos.LifeCycleState.CLOSED, HddsProtos.LifeCycleState.DELETING, HddsProtos.LifeCycleState.DELETED);
        this.makeStateTransitionIdempotent((StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent>)containerLifecycleSM, HddsProtos.LifeCycleEvent.FORCE_CLOSE, HddsProtos.LifeCycleState.CLOSED, HddsProtos.LifeCycleState.DELETING, HddsProtos.LifeCycleState.DELETED);
        this.makeStateTransitionIdempotent((StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent>)containerLifecycleSM, HddsProtos.LifeCycleEvent.DELETE, HddsProtos.LifeCycleState.DELETING, HddsProtos.LifeCycleState.DELETED);
        this.makeStateTransitionIdempotent((StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent>)containerLifecycleSM, HddsProtos.LifeCycleEvent.CLEANUP, HddsProtos.LifeCycleState.DELETED);
        return containerLifecycleSM;
    }

    private void makeStateTransitionIdempotent(StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent> sm, HddsProtos.LifeCycleEvent event, HddsProtos.LifeCycleState ... states) {
        for (HddsProtos.LifeCycleState state : states) {
            sm.addTransition((Enum)state, (Enum)state, (Enum)event);
        }
    }

    private long getConfiguredContainerSize(Configuration conf) {
        return (long)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
    }

    private void initialize() throws IOException {
        block18: {
            TableIterator iterator = this.containerStore.iterator();
            Throwable throwable = null;
            block13: while (true) {
                try {
                    while (iterator.hasNext()) {
                        ContainerInfo container = (ContainerInfo)((Table.KeyValue)iterator.next()).getValue();
                        Preconditions.checkNotNull((Object)container);
                        this.containers.addContainer(container);
                        if (container.getState() != HddsProtos.LifeCycleState.OPEN) continue;
                        try {
                            this.pipelineManager.addContainerToPipelineSCMStart(container.getPipelineID(), container.containerID());
                            continue block13;
                        }
                        catch (PipelineNotFoundException ex) {
                            LOG.warn("Found container {} which is in OPEN state with pipeline {} that does not exist. Marking container for closing.", (Object)container, (Object)container.getPipelineID());
                            try {
                                this.updateContainerState(container.containerID().getProtobuf(), HddsProtos.LifeCycleEvent.FINALIZE);
                                continue block13;
                            }
                            catch (InvalidStateTransitionException e) {
                                LOG.warn("Unable to finalize Container {}.", (Object)container);
                            }
                        }
                    }
                    break block18;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                if (iterator != null) {
                    if (throwable != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        iterator.close();
                    }
                }
            }
        }
    }

    private Map<HddsProtos.LifeCycleEvent, CheckedConsumer<ContainerInfo, IOException>> getContainerStateChangeActions() {
        EnumMap<HddsProtos.LifeCycleEvent, CheckedConsumer<ContainerInfo, IOException>> actions = new EnumMap<HddsProtos.LifeCycleEvent, CheckedConsumer<ContainerInfo, IOException>>(HddsProtos.LifeCycleEvent.class);
        actions.put(HddsProtos.LifeCycleEvent.FINALIZE, info -> this.pipelineManager.removeContainerFromPipeline(info.getPipelineID(), info.containerID()));
        return actions;
    }

    @Override
    public Set<ContainerID> getContainerIDs() {
        try (AutoCloseableLock ignored = this.readLock();){
            Set<ContainerID> set = this.containers.getAllContainerIDs();
            return set;
        }
    }

    @Override
    public Set<ContainerID> getContainerIDs(HddsProtos.LifeCycleState state) {
        try (AutoCloseableLock ignored = this.readLock();){
            NavigableSet<ContainerID> navigableSet = this.containers.getContainerIDsByState(state);
            return navigableSet;
        }
    }

    @Override
    public ContainerInfo getContainer(ContainerID id) {
        try (AutoCloseableLock ignored = this.readLock(id);){
            ContainerInfo containerInfo = this.containers.getContainerInfo(id);
            return containerInfo;
        }
    }

    @Override
    public void addContainer(HddsProtos.ContainerInfoProto containerInfo) throws IOException {
        Preconditions.checkNotNull((Object)containerInfo);
        ContainerInfo container = ContainerInfo.fromProtobuf((HddsProtos.ContainerInfoProto)containerInfo);
        ContainerID containerID = container.containerID();
        PipelineID pipelineID = container.getPipelineID();
        try (AutoCloseableLock ignoredGlobal = this.writeLock();
             AutoCloseableLock ignored = this.writeLock(containerID);){
            if (!this.containers.contains(containerID)) {
                ExecutionUtil.create(() -> {
                    this.transactionBuffer.addToBuffer(this.containerStore, (Object)containerID, (Object)container);
                    this.containers.addContainer(container);
                    if (this.pipelineManager.containsPipeline(pipelineID)) {
                        this.pipelineManager.addContainerToPipeline(pipelineID, containerID);
                    } else if (containerInfo.getState().equals((Object)HddsProtos.LifeCycleState.OPEN)) {
                        throw new PipelineNotFoundException();
                    }
                }).onException(() -> {
                    this.containers.removeContainer(containerID);
                    this.transactionBuffer.removeFromBuffer(this.containerStore, (Object)containerID);
                }).execute();
            }
        }
    }

    @Override
    public boolean contains(ContainerID id) {
        try (AutoCloseableLock ignored = this.readLock(id);){
            boolean bl = this.containers.contains(id);
            return bl;
        }
    }

    @Override
    public void updateContainerState(HddsProtos.ContainerID containerID, HddsProtos.LifeCycleEvent event) throws IOException, InvalidStateTransitionException {
        ContainerID id = ContainerID.getFromProtobuf((HddsProtos.ContainerID)containerID);
        try (AutoCloseableLock ignored = this.writeLock(id);){
            if (this.containers.contains(id)) {
                ContainerInfo oldInfo = this.containers.getContainerInfo(id);
                HddsProtos.LifeCycleState oldState = oldInfo.getState();
                HddsProtos.LifeCycleState newState = (HddsProtos.LifeCycleState)this.stateMachine.getNextState((Enum)oldInfo.getState(), (Enum)event);
                if (newState.getNumber() > oldState.getNumber()) {
                    ExecutionUtil.create(() -> {
                        this.containers.updateState(id, oldState, newState);
                        this.transactionBuffer.addToBuffer(this.containerStore, (Object)id, (Object)this.containers.getContainerInfo(id));
                    }).onException(() -> {
                        this.transactionBuffer.addToBuffer(this.containerStore, (Object)id, (Object)oldInfo);
                        this.containers.updateState(id, newState, oldState);
                    }).execute();
                    this.containerStateChangeActions.getOrDefault(event, (CheckedConsumer<ContainerInfo, IOException>)((CheckedConsumer)info -> {})).accept((Object)oldInfo);
                }
            }
        }
    }

    @Override
    public Set<ContainerReplica> getContainerReplicas(ContainerID id) {
        try (AutoCloseableLock ignored = this.readLock(id);){
            Set<ContainerReplica> set = this.containers.getContainerReplicas(id);
            return set;
        }
    }

    @Override
    public void updateContainerReplica(ContainerID id, ContainerReplica replica) {
        try (AutoCloseableLock ignored = this.writeLock(id);){
            this.containers.updateContainerReplica(id, replica);
            this.containerReplicaPendingOps.completeAddReplica(id, replica.getDatanodeDetails(), replica.getReplicaIndex());
        }
    }

    @Override
    public void removeContainerReplica(ContainerID id, ContainerReplica replica) {
        try (AutoCloseableLock ignored = this.writeLock(id);){
            this.containers.removeContainerReplica(id, replica);
            this.containerReplicaPendingOps.completeDeleteReplica(id, replica.getDatanodeDetails(), replica.getReplicaIndex());
        }
    }

    @Override
    public void updateDeleteTransactionId(Map<ContainerID, Long> deleteTransactionMap) throws IOException {
        for (Map.Entry<ContainerID, Long> transaction : deleteTransactionMap.entrySet()) {
            ContainerID containerID = transaction.getKey();
            AutoCloseableLock ignored = this.writeLock(containerID);
            Throwable throwable = null;
            try {
                ContainerInfo info = this.containers.getContainerInfo(transaction.getKey());
                if (info == null) {
                    LOG.warn("Cannot find container {}, transaction id is {}", (Object)transaction.getKey(), (Object)transaction.getValue());
                    continue;
                }
                info.updateDeleteTransactionId(transaction.getValue().longValue());
                this.transactionBuffer.addToBuffer(this.containerStore, (Object)info.containerID(), (Object)info);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
    }

    @Override
    public ContainerInfo getMatchingContainer(long size, String owner, PipelineID pipelineID, NavigableSet<ContainerID> containerIDs) {
        ContainerInfo selectedContainer;
        if (containerIDs.isEmpty()) {
            return null;
        }
        ContainerState key = new ContainerState(owner, pipelineID);
        ContainerID lastID = this.lastUsedMap.getOrDefault(key, (ContainerID)containerIDs.first());
        NavigableSet<ContainerID> resultSet = containerIDs.tailSet(lastID, false);
        if (resultSet.isEmpty()) {
            resultSet = containerIDs;
        }
        if ((selectedContainer = this.findContainerWithSpace(size, resultSet)) == null) {
            resultSet = containerIDs.headSet(lastID, true);
            selectedContainer = this.findContainerWithSpace(size, resultSet);
        }
        if (selectedContainer != null) {
            this.lastUsedMap.put(key, selectedContainer.containerID());
        }
        return selectedContainer;
    }

    private ContainerInfo findContainerWithSpace(long size, NavigableSet<ContainerID> searchSet) {
        for (ContainerID id : searchSet) {
            AutoCloseableLock ignored = this.readLock(id);
            Throwable throwable = null;
            try {
                ContainerInfo containerInfo = this.containers.getContainerInfo(id);
                if (containerInfo.getUsedBytes() + size > this.containerSize) continue;
                containerInfo.updateLastUsedTime();
                ContainerInfo containerInfo2 = containerInfo;
                return containerInfo2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        return null;
    }

    @Override
    public void removeContainer(HddsProtos.ContainerID id) throws IOException {
        ContainerID cid = ContainerID.getFromProtobuf((HddsProtos.ContainerID)id);
        try (AutoCloseableLock ignoredGlobal = this.writeLock();
             AutoCloseableLock ignored = this.writeLock(cid);){
            ContainerInfo containerInfo = this.containers.getContainerInfo(cid);
            ExecutionUtil.create(() -> {
                this.transactionBuffer.removeFromBuffer(this.containerStore, (Object)cid);
                this.containers.removeContainer(cid);
            }).onException(() -> this.containerStore.put((Object)cid, (Object)containerInfo)).execute();
        }
    }

    @Override
    public void reinitialize(Table<ContainerID, ContainerInfo> store) throws IOException {
        try (AutoCloseableLock ignored = this.writeLock();){
            this.close();
            this.containerStore = store;
            this.containers = new ContainerStateMap();
            this.lastUsedMap = new ConcurrentHashMap();
            this.initialize();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.containerStore.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private AutoCloseableLock readLock() {
        return AutoCloseableLock.acquire((Lock)this.lock.readLock());
    }

    private AutoCloseableLock writeLock() {
        return AutoCloseableLock.acquire((Lock)this.lock.writeLock());
    }

    private AutoCloseableLock readLock(ContainerID id) {
        return AutoCloseableLock.acquire((Lock)((ReadWriteLock)this.stripedLock.get((Object)id)).readLock());
    }

    private AutoCloseableLock writeLock(ContainerID id) {
        return AutoCloseableLock.acquire((Lock)((ReadWriteLock)this.stripedLock.get((Object)id)).writeLock());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Configuration conf;
        private PipelineManager pipelineMgr;
        private SCMRatisServer scmRatisServer;
        private Table<ContainerID, ContainerInfo> table;
        private DBTransactionBuffer transactionBuffer;
        private ContainerReplicaPendingOps containerReplicaPendingOps;

        public Builder setSCMDBTransactionBuffer(DBTransactionBuffer buffer) {
            this.transactionBuffer = buffer;
            return this;
        }

        public Builder setConfiguration(Configuration config) {
            this.conf = config;
            return this;
        }

        public Builder setPipelineManager(PipelineManager pipelineManager) {
            this.pipelineMgr = pipelineManager;
            return this;
        }

        public Builder setRatisServer(SCMRatisServer ratisServer) {
            this.scmRatisServer = ratisServer;
            return this;
        }

        public Builder setContainerStore(Table<ContainerID, ContainerInfo> containerStore) {
            this.table = containerStore;
            return this;
        }

        public Builder setContainerReplicaPendingOps(ContainerReplicaPendingOps pendingOps) {
            this.containerReplicaPendingOps = pendingOps;
            return this;
        }

        public ContainerStateManager build() throws IOException {
            Preconditions.checkNotNull((Object)this.conf);
            Preconditions.checkNotNull((Object)this.pipelineMgr);
            Preconditions.checkNotNull(this.table);
            ContainerStateManagerImpl csm = new ContainerStateManagerImpl(this.conf, this.pipelineMgr, this.table, this.transactionBuffer, this.containerReplicaPendingOps);
            SCMHAInvocationHandler invocationHandler = new SCMHAInvocationHandler(SCMRatisProtocol.RequestType.CONTAINER, csm, this.scmRatisServer);
            return (ContainerStateManager)Proxy.newProxyInstance(SCMHAInvocationHandler.class.getClassLoader(), new Class[]{ContainerStateManager.class}, (InvocationHandler)invocationHandler);
        }
    }
}

