/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.PlacementPolicyValidateProxy;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.balancer.AbstractFindTargetGreedy;
import org.apache.hadoop.hdds.scm.node.DatanodeUsageInfo;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class FindTargetGreedyByUsageInfo
extends AbstractFindTargetGreedy {
    public FindTargetGreedyByUsageInfo(ContainerManager containerManager, PlacementPolicyValidateProxy placementPolicyValidateProxy, NodeManager nodeManager) {
        super(containerManager, placementPolicyValidateProxy, nodeManager);
        this.setLogger(LoggerFactory.getLogger(FindTargetGreedyByUsageInfo.class));
        this.setPotentialTargets(new TreeSet<DatanodeUsageInfo>((a, b) -> this.compareByUsage((DatanodeUsageInfo)a, (DatanodeUsageInfo)b)));
    }

    @Override
    @VisibleForTesting
    public void sortTargetForSource(DatanodeDetails source) {
    }

    @Override
    public void resetPotentialTargets(@NotNull Collection<DatanodeDetails> targets) {
        ArrayList<DatanodeUsageInfo> usageInfos = new ArrayList<DatanodeUsageInfo>(targets.size());
        targets.forEach(datanodeDetails -> usageInfos.add(this.getNodeManager().getUsageInfo((DatanodeDetails)datanodeDetails)));
        super.resetTargets(usageInfos);
    }
}

