/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.RatisContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManagerUtil;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatisReplicationCheckHandler
extends AbstractCheck {
    public static final Logger LOG = LoggerFactory.getLogger(RatisReplicationCheckHandler.class);
    private final PlacementPolicy ratisContainerPlacement;
    private final ReplicationManager replicationManager;

    public RatisReplicationCheckHandler(PlacementPolicy containerPlacement, ReplicationManager replicationManager) {
        this.ratisContainerPlacement = containerPlacement;
        this.replicationManager = replicationManager;
    }

    @Override
    public boolean handle(ContainerCheckRequest request) {
        if (request.getContainerInfo().getReplicationType() != HddsProtos.ReplicationType.RATIS) {
            return false;
        }
        ReplicationManagerReport report = request.getReport();
        ContainerInfo container = request.getContainerInfo();
        ContainerHealthResult health = this.checkHealth(request);
        LOG.debug("Checking container {} in RatisReplicationCheckHandler", (Object)container);
        if (health.getHealthState() == ContainerHealthResult.HealthState.HEALTHY || health.getHealthState() == ContainerHealthResult.HealthState.UNHEALTHY) {
            return false;
        }
        if (health.getHealthState() == ContainerHealthResult.HealthState.UNDER_REPLICATED) {
            ContainerHealthResult.UnderReplicatedHealthResult underHealth = (ContainerHealthResult.UnderReplicatedHealthResult)health;
            if (!underHealth.isUnrecoverable() && !underHealth.hasHealthyReplicas()) {
                return false;
            }
            LOG.debug("Container {} is Under Replicated. isReplicatedOkAfterPending is [{}]. isUnrecoverable is [{}]. hasHealthyReplicas is [{}].", new Object[]{container, underHealth.isReplicatedOkAfterPending(), underHealth.isUnrecoverable(), underHealth.hasHealthyReplicas()});
            if (underHealth.isUnrecoverable()) {
                report.incrementAndSample(ReplicationManagerReport.HealthState.MISSING, container.containerID());
                return true;
            }
            report.incrementAndSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED, container.containerID());
            if (!underHealth.isReplicatedOkAfterPending() && underHealth.hasHealthyReplicas()) {
                request.getReplicationQueue().enqueue(underHealth);
            }
            return true;
        }
        if (health.getHealthState() == ContainerHealthResult.HealthState.OVER_REPLICATED) {
            report.incrementAndSample(ReplicationManagerReport.HealthState.OVER_REPLICATED, container.containerID());
            ContainerHealthResult.OverReplicatedHealthResult overHealth = (ContainerHealthResult.OverReplicatedHealthResult)health;
            if (!overHealth.isReplicatedOkAfterPending() && !overHealth.hasMismatchedReplicas() && overHealth.isSafelyOverReplicated()) {
                request.getReplicationQueue().enqueue(overHealth);
            }
            LOG.debug("Container {} is Over Replicated. isReplicatedOkAfterPending is [{}]. hasMismatchedReplicas is [{}]. isSafelyOverReplicated is [{}].", new Object[]{container, overHealth.isReplicatedOkAfterPending(), overHealth.hasMismatchedReplicas(), overHealth.isSafelyOverReplicated()});
            return true;
        }
        if (health.getHealthState() == ContainerHealthResult.HealthState.MIS_REPLICATED) {
            report.incrementAndSample(ReplicationManagerReport.HealthState.MIS_REPLICATED, container.containerID());
            ContainerHealthResult.MisReplicatedHealthResult misRepHealth = (ContainerHealthResult.MisReplicatedHealthResult)health;
            if (!misRepHealth.isReplicatedOkAfterPending()) {
                request.getReplicationQueue().enqueue(misRepHealth);
            }
            LOG.debug("Container {} is Mis Replicated. isReplicatedOkAfterPending is [{}]. Reason for mis replication is [{}].", new Object[]{container, misRepHealth.isReplicatedOkAfterPending(), misRepHealth.getMisReplicatedReason()});
            return true;
        }
        LOG.warn("Container {} is not healthy but is not under, over or  mis-replicated. Should not happen.", (Object)container);
        return false;
    }

    public ContainerHealthResult checkHealth(ContainerCheckRequest request) {
        ContainerPlacementStatus placementStatus;
        int minReplicasForMaintenance;
        List<ContainerReplicaOp> replicaPendingOps;
        Set<ContainerReplica> replicas;
        ContainerInfo container = request.getContainerInfo();
        RatisContainerReplicaCount replicaCount = new RatisContainerReplicaCount(container, replicas = request.getContainerReplicas(), replicaPendingOps = request.getPendingOps(), minReplicasForMaintenance = request.getMaintenanceRedundancy(), false);
        boolean sufficientlyReplicated = replicaCount.isSufficientlyReplicated(false);
        if (!sufficientlyReplicated) {
            return replicaCount.toUnderHealthResult();
        }
        if (replicaCount.isOverReplicated(false)) {
            return replicaCount.toOverHealthResult();
        }
        RatisContainerReplicaCount consideringUnhealthy = new RatisContainerReplicaCount(container, replicas, replicaPendingOps, minReplicasForMaintenance, true);
        if (consideringUnhealthy.isOverReplicated(false)) {
            if (container.getState() == HddsProtos.LifeCycleState.CLOSED) {
                return consideringUnhealthy.toOverHealthResult();
            }
            if (container.getState() == HddsProtos.LifeCycleState.QUASI_CLOSED) {
                ContainerReplica toDelete = ReplicationManagerUtil.selectUnhealthyReplicaForDelete(container, replicas, 0, dnd -> {
                    try {
                        return this.replicationManager.getNodeStatus((DatanodeDetails)dnd);
                    }
                    catch (NodeNotFoundException e) {
                        return null;
                    }
                });
                if (toDelete != null) {
                    return consideringUnhealthy.toOverHealthResult();
                }
                return new ContainerHealthResult.HealthyResult(container);
            }
        }
        int requiredNodes = container.getReplicationConfig().getRequiredNodes();
        ContainerPlacementStatus placementStatusWithPending = placementStatus = this.getPlacementStatus(replicas, requiredNodes, Collections.emptyList());
        if (!placementStatus.isPolicySatisfied()) {
            if (replicaPendingOps.size() > 0) {
                placementStatusWithPending = this.getPlacementStatus(replicas, requiredNodes, replicaPendingOps);
            }
            return new ContainerHealthResult.MisReplicatedHealthResult(container, placementStatusWithPending.isPolicySatisfied(), placementStatusWithPending.misReplicatedReason());
        }
        if (replicaCount.getUnhealthyReplicaCount() != 0) {
            return new ContainerHealthResult.UnHealthyResult(container);
        }
        return new ContainerHealthResult.HealthyResult(container);
    }

    private ContainerPlacementStatus getPlacementStatus(Set<ContainerReplica> replicas, int replicationFactor, List<ContainerReplicaOp> pendingOps) {
        Set replicaDns = replicas.stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toSet());
        for (ContainerReplicaOp op : pendingOps) {
            if (op.getOpType() == ContainerReplicaOp.PendingOpType.ADD) {
                replicaDns.add(op.getTarget());
            }
            if (op.getOpType() != ContainerReplicaOp.PendingOpType.DELETE) continue;
            replicaDns.remove(op.getTarget());
        }
        return this.ratisContainerPlacement.validateContainerPlacement(new ArrayList<DatanodeDetails>(replicaDns), replicationFactor);
    }
}

