/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.report;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerReportValidator {
    private Map<HddsProtos.ReplicationType, ReplicaValidator> replicaValidators = ImmutableMap.of((Object)HddsProtos.ReplicationType.EC, (Object)new ECReplicaValidator());
    private static final ContainerReportValidator CONTAINER_REPORT_VALIDATOR = new ContainerReportValidator();

    private ContainerReportValidator() {
    }

    private static boolean validateReplica(ReplicationConfig replicationConfig, DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto) {
        return Optional.ofNullable(replicationConfig.getReplicationType()).map(ContainerReportValidator.CONTAINER_REPORT_VALIDATOR.replicaValidators::get).map(replicaValidator -> replicaValidator.validate(replicationConfig, datanodeDetails, replicaProto)).orElse(true);
    }

    public static boolean validate(ContainerInfo containerInfo, DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto) {
        return ContainerReportValidator.validateReplica(containerInfo.getReplicationConfig(), datanodeDetails, replicaProto);
    }

    private static class ECReplicaValidator
    implements ReplicaValidator {
        private static final Logger LOG = LoggerFactory.getLogger(ECReplicaValidator.class);

        private ECReplicaValidator() {
        }

        @Override
        public boolean validate(ReplicationConfig replicationConfig, DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto) {
            boolean validReplicaIndex;
            if (replicationConfig.getReplicationType() != HddsProtos.ReplicationType.EC) {
                LOG.error("Provided Replication Config: {} is not EC replication config", (Object)replicationConfig.getReplicationType());
                return false;
            }
            boolean bl = validReplicaIndex = replicaProto.hasReplicaIndex() && replicaProto.getReplicaIndex() > 0 && replicaProto.getReplicaIndex() <= replicationConfig.getRequiredNodes();
            if (!validReplicaIndex) {
                LOG.error("ContainerReplicaReport for ContainerID: {} in Datanode: {} failed. Replica Index should be between 1 and {}. Given Replica Index: {}", new Object[]{replicaProto.getContainerID(), datanodeDetails, replicationConfig.getRequiredNodes(), replicaProto.getReplicaIndex()});
            }
            return validReplicaIndex;
        }
    }

    private static interface ReplicaValidator {
        public boolean validate(ReplicationConfig var1, DatanodeDetails var2, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto var3);
    }
}

