/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationCheckpoint;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMContext {
    private static final Logger LOG = LoggerFactory.getLogger(SCMContext.class);
    public static final long INVALID_TERM = -1L;
    private final String threadNamePrefix;
    private boolean isLeader;
    private boolean isLeaderReady;
    private long term;
    private SCMSafeModeManager.SafeModeStatus safeModeStatus;
    private final OzoneStorageContainerManager scm;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile FinalizationCheckpoint finalizationCheckpoint;

    public static SCMContext emptyContext() {
        return new Builder().buildMaybeInvalid();
    }

    private SCMContext(boolean isLeader, long term, SCMSafeModeManager.SafeModeStatus safeModeStatus, FinalizationCheckpoint finalizationCheckpoint, OzoneStorageContainerManager scm, String threadNamePrefix) {
        this.isLeader = isLeader;
        this.term = term;
        this.safeModeStatus = safeModeStatus;
        this.finalizationCheckpoint = finalizationCheckpoint;
        this.scm = scm;
        this.isLeaderReady = false;
        this.threadNamePrefix = threadNamePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLeaderAndTerm(boolean leader, long newTerm) {
        this.lock.writeLock().lock();
        try {
            LOG.info("update <isLeader,term> from <{},{}> to <{},{}>", new Object[]{this.isLeader, this.term, leader, newTerm});
            this.isLeader = leader;
            if (!this.isLeader) {
                this.isLeaderReady = false;
                LOG.info("update <isLeaderReady> from <{}> to <{}>", (Object)this.isLeaderReady, (Object)false);
            }
            this.term = newTerm;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setLeaderReady() {
        this.lock.writeLock().lock();
        try {
            LOG.info("update <isLeaderReady> from <{}> to <{}>", (Object)this.isLeaderReady, (Object)true);
            this.isLeaderReady = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setFinalizationCheckpoint(FinalizationCheckpoint checkpoint) {
        this.lock.writeLock().lock();
        try {
            this.finalizationCheckpoint = checkpoint;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isLeader() {
        this.lock.readLock().lock();
        try {
            if (this.term == -1L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.isLeader;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isLeaderReady() {
        this.lock.readLock().lock();
        try {
            if (this.term == -1L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.isLeaderReady;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getTermOfLeader() throws NotLeaderException {
        this.lock.readLock().lock();
        try {
            if (this.term == -1L) {
                long l = this.term;
                return l;
            }
            if (!this.isLeader) {
                LOG.warn("getTerm is invoked when not leader.");
                if (this.scm instanceof StorageContainerManager) {
                    StorageContainerManager storageContainerManager = (StorageContainerManager)this.scm;
                    throw storageContainerManager.getScmHAManager().getRatisServer().triggerNotLeaderException();
                }
            }
            long l = this.term;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void updateSafeModeStatus(SCMSafeModeManager.SafeModeStatus status) {
        this.lock.writeLock().lock();
        try {
            LOG.info("Update SafeModeStatus from {} to {}.", (Object)this.safeModeStatus, (Object)status);
            this.safeModeStatus = status;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isInSafeMode() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.safeModeStatus.isInSafeMode();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isPreCheckComplete() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.safeModeStatus.isPreCheckComplete();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public FinalizationCheckpoint getFinalizationCheckpoint() {
        this.lock.readLock().lock();
        try {
            FinalizationCheckpoint finalizationCheckpoint = this.finalizationCheckpoint;
            return finalizationCheckpoint;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public OzoneStorageContainerManager getScm() {
        return this.scm;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public static class Builder {
        private boolean isLeader = false;
        private long term = -1L;
        private boolean isInSafeMode = false;
        private boolean isPreCheckComplete = true;
        private OzoneStorageContainerManager scm = null;
        private FinalizationCheckpoint finalizationCheckpoint;
        private String threadNamePrefix = "";

        public Builder setLeader(boolean leader) {
            this.isLeader = leader;
            return this;
        }

        public Builder setTerm(long newTerm) {
            this.term = newTerm;
            return this;
        }

        public Builder setIsInSafeMode(boolean inSafeMode) {
            this.isInSafeMode = inSafeMode;
            return this;
        }

        public Builder setIsPreCheckComplete(boolean preCheckComplete) {
            this.isPreCheckComplete = preCheckComplete;
            return this;
        }

        public Builder setSCM(OzoneStorageContainerManager storageContainerManager) {
            this.scm = storageContainerManager;
            return this;
        }

        public Builder setFinalizationCheckpoint(FinalizationCheckpoint checkpoint) {
            this.finalizationCheckpoint = checkpoint;
            return this;
        }

        public Builder setThreadNamePrefix(String prefix) {
            this.threadNamePrefix = prefix;
            return this;
        }

        public SCMContext build() {
            Preconditions.checkNotNull((Object)this.scm, (Object)"scm == null");
            return this.buildMaybeInvalid();
        }

        @VisibleForTesting
        SCMContext buildMaybeInvalid() {
            return new SCMContext(this.isLeader, this.term, new SCMSafeModeManager.SafeModeStatus(this.isInSafeMode, this.isPreCheckComplete), Optional.ofNullable(this.finalizationCheckpoint).orElse(FinalizationCheckpoint.FINALIZATION_COMPLETE), this.scm, this.threadNamePrefix);
        }
    }
}

