/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;

public class CommandQueue {
    private final Map<UUID, Commands> commandMap = new HashMap<UUID, Commands>();
    private long commandsInQueue = 0L;

    public long getCommandsInQueue() {
        return this.commandsInQueue;
    }

    @VisibleForTesting
    public void clear() {
        this.commandMap.clear();
        this.commandsInQueue = 0L;
    }

    List<SCMCommand> getCommand(UUID datanodeUuid) {
        Commands cmds = this.commandMap.remove(datanodeUuid);
        List<SCMCommand> cmdList = null;
        if (cmds != null) {
            cmdList = cmds.getCommands();
            this.commandsInQueue -= cmdList.size() > 0 ? (long)cmdList.size() : 0L;
            Preconditions.checkState((this.commandsInQueue >= 0L ? 1 : 0) != 0);
        }
        return cmds == null ? Collections.emptyList() : cmdList;
    }

    public int getDatanodeCommandCount(UUID datanodeUuid, StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type commandType) {
        Commands commands = this.commandMap.get(datanodeUuid);
        if (commands == null) {
            return 0;
        }
        return commands.getCommandSummary(commandType);
    }

    public Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> getDatanodeCommandSummary(UUID datanodeUuid) {
        Commands commands = this.commandMap.get(datanodeUuid);
        if (commands == null) {
            return Collections.emptyMap();
        }
        return commands.getAllCommandsSummary();
    }

    public void addCommand(UUID datanodeUuid, SCMCommand command) {
        this.commandMap.computeIfAbsent(datanodeUuid, s -> new Commands()).add(command);
        ++this.commandsInQueue;
    }

    private static class Commands {
        private long updateTime = 0L;
        private long readTime = 0L;
        private List<SCMCommand> commands = new ArrayList<SCMCommand>();
        private final Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> summary = new HashMap<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer>();

        private Commands() {
        }

        public long getUpdateTime() {
            return this.updateTime;
        }

        public long getReadTime() {
            return this.readTime;
        }

        public void add(SCMCommand command) {
            this.commands.add(command);
            if (command.contributesToQueueSize()) {
                this.summary.put(command.getType(), this.summary.getOrDefault(command.getType(), 0) + 1);
            }
            this.updateTime = Time.monotonicNow();
        }

        public int getCommandSummary(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type commandType) {
            return this.summary.getOrDefault(commandType, 0);
        }

        public Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> getAllCommandsSummary() {
            return new HashMap<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer>(this.summary);
        }

        public List<SCMCommand> getCommands() {
            List<SCMCommand> temp = this.commands;
            this.commands = new ArrayList<SCMCommand>();
            this.summary.clear();
            this.readTime = Time.monotonicNow();
            return temp;
        }
    }
}

