/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(about="Node Decommission Metrics", context="ozone")
public final class NodeDecommissionMetrics
implements MetricsSource {
    public static final String METRICS_SOURCE_NAME = NodeDecommissionMetrics.class.getSimpleName();
    @Metric(value={"Number of nodes tracked for decommissioning and maintenance."})
    private MutableGaugeLong decommissioningMaintenanceNodesTotal;
    @Metric(value={"Number of nodes tracked for recommissioning."})
    private MutableGaugeLong recommissionNodesTotal;
    @Metric(value={"Number of nodes tracked with pipelines waiting to close."})
    private MutableGaugeLong pipelinesWaitingToCloseTotal;
    @Metric(value={"Number of containers under replicated in tracked nodes."})
    private MutableGaugeLong containersUnderReplicatedTotal;
    @Metric(value={"Number of containers not fully closed in tracked nodes."})
    private MutableGaugeLong containersUnClosedTotal;
    @Metric(value={"Number of containers sufficiently replicated in tracked nodes."})
    private MutableGaugeLong containersSufficientlyReplicatedTotal;
    private MetricsRegistry registry = new MetricsRegistry(METRICS_SOURCE_NAME);
    private Map<String, ContainerStateInWorkflow> metricsByHost = new HashMap<String, ContainerStateInWorkflow>();

    private NodeDecommissionMetrics() {
    }

    public static NodeDecommissionMetrics create() {
        return (NodeDecommissionMetrics)DefaultMetricsSystem.instance().register(METRICS_SOURCE_NAME, "Metrics tracking the progress of nodes in the Decommissioning and Maintenance workflows.  Tracks num nodes in mode and container replications state and pipelines waiting to close", (Object)new NodeDecommissionMetrics());
    }

    public synchronized void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(METRICS_SOURCE_NAME);
        this.decommissioningMaintenanceNodesTotal.snapshot(builder, all);
        this.recommissionNodesTotal.snapshot(builder, all);
        this.pipelinesWaitingToCloseTotal.snapshot(builder, all);
        this.containersUnderReplicatedTotal.snapshot(builder, all);
        this.containersUnClosedTotal.snapshot(builder, all);
        this.containersSufficientlyReplicatedTotal.snapshot(builder, all);
        MetricsRecordBuilder recordBuilder = builder;
        for (Map.Entry<String, ContainerStateInWorkflow> e : this.metricsByHost.entrySet()) {
            recordBuilder = recordBuilder.endRecord().addRecord(METRICS_SOURCE_NAME).add(new MetricsTag(Interns.info((String)"datanode", (String)"datanode host in decommission maintenance workflow"), e.getValue().getHost())).addGauge(ContainerStateInWorkflow.HOST_PIPELINES_TO_CLOSE, e.getValue().getPipelinesWaitingToClose()).addGauge(ContainerStateInWorkflow.HOST_UNDER_REPLICATED, e.getValue().getUnderReplicatedContainers()).addGauge(ContainerStateInWorkflow.HOST_SUFFICIENTLY_REPLICATED, e.getValue().getSufficientlyReplicated()).addGauge(ContainerStateInWorkflow.HOST_UNCLOSED_CONTAINERS, e.getValue().getUnclosedContainers());
        }
        recordBuilder.endRecord();
    }

    public void unRegister() {
        DefaultMetricsSystem.instance().unregisterSource(METRICS_SOURCE_NAME);
    }

    public synchronized void setDecommissioningMaintenanceNodesTotal(long numNodesTracked) {
        this.decommissioningMaintenanceNodesTotal.set(numNodesTracked);
    }

    public synchronized void setRecommissionNodesTotal(long numNodesTrackedRecommissioned) {
        this.recommissionNodesTotal.set(numNodesTrackedRecommissioned);
    }

    public synchronized void setPipelinesWaitingToCloseTotal(long numTrackedPipelinesWaitToClose) {
        this.pipelinesWaitingToCloseTotal.set(numTrackedPipelinesWaitToClose);
    }

    public synchronized void setContainersUnderReplicatedTotal(long numTrackedUnderReplicated) {
        this.containersUnderReplicatedTotal.set(numTrackedUnderReplicated);
    }

    public synchronized void setContainersUnClosedTotal(long numTrackedUnclosed) {
        this.containersUnClosedTotal.set(numTrackedUnclosed);
    }

    public synchronized void setContainersSufficientlyReplicatedTotal(long numTrackedSufficientlyReplicated) {
        this.containersSufficientlyReplicatedTotal.set(numTrackedSufficientlyReplicated);
    }

    public synchronized long getDecommissioningMaintenanceNodesTotal() {
        return this.decommissioningMaintenanceNodesTotal.value();
    }

    public synchronized long getRecommissionNodesTotal() {
        return this.recommissionNodesTotal.value();
    }

    public synchronized long getPipelinesWaitingToCloseTotal() {
        return this.pipelinesWaitingToCloseTotal.value();
    }

    public synchronized long getContainersUnderReplicatedTotal() {
        return this.containersUnderReplicatedTotal.value();
    }

    public synchronized long getContainersUnClosedTotal() {
        return this.containersUnClosedTotal.value();
    }

    public synchronized long getContainersSufficientlyReplicatedTotal() {
        return this.containersSufficientlyReplicatedTotal.value();
    }

    public synchronized void metricRecordOfContainerStateByHost(Map<String, ContainerStateInWorkflow> containerStatesByHost) {
        this.metricsByHost.clear();
        this.metricsByHost.putAll(containerStatesByHost);
    }

    @VisibleForTesting
    public Long getPipelinesWaitingToCloseByHost(String host) {
        ContainerStateInWorkflow workflowMetrics = this.metricsByHost.get(host);
        return workflowMetrics == null ? null : Long.valueOf(workflowMetrics.getPipelinesWaitingToClose());
    }

    @VisibleForTesting
    public Long getSufficientlyReplicatedByHost(String host) {
        ContainerStateInWorkflow workflowMetrics = this.metricsByHost.get(host);
        return workflowMetrics == null ? null : Long.valueOf(workflowMetrics.getSufficientlyReplicated());
    }

    @VisibleForTesting
    public Long getUnderReplicatedByHost(String host) {
        ContainerStateInWorkflow workflowMetrics = this.metricsByHost.get(host);
        return workflowMetrics == null ? null : Long.valueOf(workflowMetrics.getUnderReplicatedContainers());
    }

    @VisibleForTesting
    public Long getUnClosedContainersByHost(String host) {
        ContainerStateInWorkflow workflowMetrics = this.metricsByHost.get(host);
        return workflowMetrics == null ? null : Long.valueOf(workflowMetrics.getUnclosedContainers());
    }

    public static final class ContainerStateInWorkflow {
        private long sufficientlyReplicated = 0L;
        private long unclosedContainers = 0L;
        private long underReplicatedContainers = 0L;
        private String host = "";
        private long pipelinesWaitingToClose = 0L;
        private static final MetricsInfo HOST_UNDER_REPLICATED = Interns.info((String)"UnderReplicatedDN", (String)"Number of under-replicated containers for host in decommissioning and maintenance mode");
        private static final MetricsInfo HOST_PIPELINES_TO_CLOSE = Interns.info((String)"PipelinesWaitingToCloseDN", (String)"Number of pipelines waiting to close for host in decommissioning and maintenance mode");
        private static final MetricsInfo HOST_SUFFICIENTLY_REPLICATED = Interns.info((String)"SufficientlyReplicatedDN", (String)"Number of sufficiently replicated containers for host in decommissioning and maintenance mode");
        private static final MetricsInfo HOST_UNCLOSED_CONTAINERS = Interns.info((String)"UnclosedContainersDN", (String)"Number of containers not fully closed for host in decommissioning and maintenance mode");

        public ContainerStateInWorkflow(String host, long sufficiently, long under, long unclosed, long pipelinesToClose) {
            this.host = host;
            this.sufficientlyReplicated = sufficiently;
            this.underReplicatedContainers = under;
            this.unclosedContainers = unclosed;
            this.pipelinesWaitingToClose = pipelinesToClose;
        }

        public String getHost() {
            return this.host;
        }

        public long getSufficientlyReplicated() {
            return this.sufficientlyReplicated;
        }

        public long getPipelinesWaitingToClose() {
            return this.pipelinesWaitingToClose;
        }

        public long getUnderReplicatedContainers() {
            return this.underReplicatedContainers;
        }

        public long getUnclosedContainers() {
            return this.unclosedContainers;
        }
    }
}

