/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.PipelineChoosePolicy;
import org.apache.hadoop.hdds.scm.PipelineRequestInformation;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.WritableContainerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritableRatisContainerProvider
implements WritableContainerProvider<ReplicationConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(WritableRatisContainerProvider.class);
    private final ConfigurationSource conf;
    private final PipelineManager pipelineManager;
    private final PipelineChoosePolicy pipelineChoosePolicy;
    private final ContainerManager containerManager;

    public WritableRatisContainerProvider(ConfigurationSource conf, PipelineManager pipelineManager, ContainerManager containerManager, PipelineChoosePolicy pipelineChoosePolicy) {
        this.conf = conf;
        this.pipelineManager = pipelineManager;
        this.containerManager = containerManager;
        this.pipelineChoosePolicy = pipelineChoosePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerInfo getContainer(long size, ReplicationConfig repConfig, String owner, ExcludeList excludeList) throws IOException {
        ContainerInfo containerInfo = null;
        String failureReason = null;
        while (true) {
            ContainerInfo containerInfo2;
            List<Pipeline> availablePipelines;
            this.pipelineManager.acquireReadLock();
            try {
                availablePipelines = this.findPipelinesByState(repConfig, excludeList, Pipeline.PipelineState.OPEN);
                if (availablePipelines.size() != 0) {
                    containerInfo = this.selectContainer(availablePipelines, size, owner, excludeList);
                }
                if (containerInfo != null) {
                    containerInfo2 = containerInfo;
                    return containerInfo2;
                }
            }
            finally {
                this.pipelineManager.releaseReadLock();
            }
            if (availablePipelines.size() != 0) continue;
            try {
                Pipeline pipeline = this.pipelineManager.createPipeline(repConfig);
                this.pipelineManager.waitPipelineReady(pipeline.getId(), 0L);
            }
            catch (SCMException se) {
                LOG.warn("Pipeline creation failed for repConfig {} Datanodes may be used up. Try to see if any pipeline is in ALLOCATED state, and then will wait for it to be OPEN", (Object)repConfig, (Object)se);
                List<Pipeline> allocatedPipelines = this.findPipelinesByState(repConfig, excludeList, Pipeline.PipelineState.ALLOCATED);
                if (!allocatedPipelines.isEmpty()) {
                    List<PipelineID> allocatedPipelineIDs = allocatedPipelines.stream().map(p -> p.getId()).collect(Collectors.toList());
                    try {
                        this.pipelineManager.waitOnePipelineReady(allocatedPipelineIDs, 0L);
                    }
                    catch (IOException e) {
                        LOG.warn("Waiting for one of pipelines {} to be OPEN failed. ", allocatedPipelineIDs, (Object)e);
                        failureReason = "Waiting for one of pipelines to be OPEN failed. " + e.getMessage();
                    }
                } else {
                    failureReason = se.getMessage();
                }
            }
            catch (IOException e) {
                LOG.warn("Pipeline creation failed for repConfig: {}. Retrying get pipelines call once.", (Object)repConfig, (Object)e);
                failureReason = e.getMessage();
            }
            this.pipelineManager.acquireReadLock();
            try {
                availablePipelines = this.findPipelinesByState(repConfig, excludeList, Pipeline.PipelineState.OPEN);
                if (availablePipelines.size() != 0) {
                    containerInfo = this.selectContainer(availablePipelines, size, owner, excludeList);
                    if (containerInfo == null) continue;
                    containerInfo2 = containerInfo;
                    return containerInfo2;
                }
                LOG.info("Could not find available pipeline of repConfig: {} even after retrying", (Object)repConfig);
            }
            finally {
                this.pipelineManager.releaseReadLock();
                continue;
            }
            break;
        }
        LOG.error("Unable to allocate a block for the size: {}, repConfig: {}", (Object)size, (Object)repConfig);
        throw new IOException("Unable to allocate a container to the block of size: " + size + ", replicationConfig: " + repConfig + ". " + failureReason);
    }

    private List<Pipeline> findPipelinesByState(ReplicationConfig repConfig, ExcludeList excludeList, Pipeline.PipelineState pipelineState) {
        List<Pipeline> pipelines = this.pipelineManager.getPipelines(repConfig, pipelineState, excludeList.getDatanodes(), excludeList.getPipelineIds());
        if (pipelines.size() == 0 && !excludeList.isEmpty()) {
            pipelines = this.pipelineManager.getPipelines(repConfig, pipelineState);
        }
        return pipelines;
    }

    private ContainerInfo selectContainer(List<Pipeline> availablePipelines, long size, String owner, ExcludeList excludeList) {
        PipelineRequestInformation pri = PipelineRequestInformation.Builder.getBuilder().setSize(size).build();
        Pipeline pipeline = this.pipelineChoosePolicy.choosePipeline(availablePipelines, pri);
        ContainerInfo containerInfo = this.containerManager.getMatchingContainer(size, owner, pipeline, excludeList.getContainerIds());
        return containerInfo;
    }
}

