/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline.choose.algorithms;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Constructor;
import org.apache.hadoop.hdds.scm.PipelineChoosePolicy;
import org.apache.hadoop.hdds.scm.ScmConfig;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.choose.algorithms.RandomPipelineChoosePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineChoosePolicyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineChoosePolicyFactory.class);
    @VisibleForTesting
    public static final Class<? extends PipelineChoosePolicy> OZONE_SCM_PIPELINE_CHOOSE_POLICY_IMPL_DEFAULT = RandomPipelineChoosePolicy.class;
    @VisibleForTesting
    public static final Class<? extends PipelineChoosePolicy> OZONE_SCM_EC_PIPELINE_CHOOSE_POLICY_IMPL_DEFAULT = RandomPipelineChoosePolicy.class;

    private PipelineChoosePolicyFactory() {
    }

    public static PipelineChoosePolicy getPolicy(ScmConfig scmConfig, boolean forEC) throws SCMException {
        Class<PipelineChoosePolicy> policyClass = null;
        String policyName = forEC ? scmConfig.getECPipelineChoosePolicyName() : scmConfig.getPipelineChoosePolicyName();
        try {
            policyClass = PipelineChoosePolicyFactory.getClass(policyName, PipelineChoosePolicy.class);
            return PipelineChoosePolicyFactory.createPipelineChoosePolicyFromClass(policyClass);
        }
        catch (Exception e) {
            Class<? extends PipelineChoosePolicy> defaultPolicy;
            Class<? extends PipelineChoosePolicy> clazz = defaultPolicy = forEC ? OZONE_SCM_EC_PIPELINE_CHOOSE_POLICY_IMPL_DEFAULT : OZONE_SCM_PIPELINE_CHOOSE_POLICY_IMPL_DEFAULT;
            if (policyClass == null || policyClass != defaultPolicy) {
                LOG.error("Met an exception while create pipeline choose policy for the given class {}. Fallback to the default pipeline  choose policy {}", new Object[]{policyName, defaultPolicy, e});
                return PipelineChoosePolicyFactory.createPipelineChoosePolicyFromClass(defaultPolicy);
            }
            throw e;
        }
    }

    private static PipelineChoosePolicy createPipelineChoosePolicyFromClass(Class<? extends PipelineChoosePolicy> policyClass) throws SCMException {
        Constructor<? extends PipelineChoosePolicy> constructor;
        try {
            constructor = policyClass.getDeclaredConstructor(new Class[0]);
            LOG.info("Create pipeline choose policy of type {}", (Object)policyClass.getCanonicalName());
        }
        catch (NoSuchMethodException e) {
            String msg = "Failed to find constructor() for class " + policyClass.getCanonicalName();
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_INIT_PIPELINE_CHOOSE_POLICY);
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate class " + policyClass.getCanonicalName() + " for " + e.getMessage());
        }
    }

    private static <U> Class<? extends U> getClass(String name, Class<U> xface) {
        try {
            Class<?> theClass = Class.forName(name);
            if (!xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            return theClass.asSubclass(xface);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

