/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

public class SafeModeMetrics {
    private static final String SOURCE_NAME = SafeModeMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numContainerWithOneReplicaReportedThreshold;
    @Metric
    private MutableCounterLong currentContainersWithOneReplicaReportedCount;
    @Metric
    private MutableCounterLong numHealthyPipelinesThreshold;
    @Metric
    private MutableCounterLong currentHealthyPipelinesCount;
    @Metric
    private MutableCounterLong numPipelinesWithAtleastOneReplicaReportedThreshold;
    @Metric
    private MutableCounterLong currentPipelinesWithAtleastOneReplicaReportedCount;

    public static SafeModeMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (SafeModeMetrics)ms.register(SOURCE_NAME, "SCM Safemode Metrics", (Object)new SafeModeMetrics());
    }

    public void setNumHealthyPipelinesThreshold(long val) {
        this.numHealthyPipelinesThreshold.incr(val);
    }

    public void incCurrentHealthyPipelinesCount() {
        this.currentHealthyPipelinesCount.incr();
    }

    public void setNumPipelinesWithAtleastOneReplicaReportedThreshold(long val) {
        this.numPipelinesWithAtleastOneReplicaReportedThreshold.incr(val);
    }

    public void incCurrentHealthyPipelinesWithAtleastOneReplicaReportedCount() {
        this.currentPipelinesWithAtleastOneReplicaReportedCount.incr();
    }

    public void setNumContainerWithOneReplicaReportedThreshold(long val) {
        this.numContainerWithOneReplicaReportedThreshold.incr(val);
    }

    public void incCurrentContainersWithOneReplicaReportedCount() {
        this.currentContainersWithOneReplicaReportedCount.incr();
    }

    public MutableCounterLong getNumHealthyPipelinesThreshold() {
        return this.numHealthyPipelinesThreshold;
    }

    public MutableCounterLong getCurrentHealthyPipelinesCount() {
        return this.currentHealthyPipelinesCount;
    }

    public MutableCounterLong getNumPipelinesWithAtleastOneReplicaReportedThreshold() {
        return this.numPipelinesWithAtleastOneReplicaReportedThreshold;
    }

    public MutableCounterLong getCurrentPipelinesWithAtleastOneReplicaCount() {
        return this.currentPipelinesWithAtleastOneReplicaReportedCount;
    }

    public MutableCounterLong getNumContainerWithOneReplicaReportedThreshold() {
        return this.numContainerWithOneReplicaReportedThreshold;
    }

    public MutableCounterLong getCurrentContainersWithOneReplicaReportedCount() {
        return this.currentContainersWithOneReplicaReportedCount;
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

