/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.security;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.security.x509.crl.CRLStatus;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLStatusReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.CRLStatusReportFromDatanode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRLStatusReportHandler.class);
    private CertificateStore certStore = null;
    private final boolean isSecurityEnabled;

    public CRLStatusReportHandler(CertificateStore certificateStore, OzoneConfiguration conf) {
        this.isSecurityEnabled = OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf);
        if (this.isSecurityEnabled) {
            Preconditions.checkNotNull((Object)certificateStore);
            this.certStore = certificateStore;
        }
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.CRLStatusReportFromDatanode reportFromDatanode, EventPublisher publisher) {
        if (this.isSecurityEnabled) {
            Preconditions.checkNotNull((Object)reportFromDatanode);
            DatanodeDetails dn = reportFromDatanode.getDatanodeDetails();
            Preconditions.checkNotNull((Object)dn, (Object)"CRLStatusReport is missing DatanodeDetails.");
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Processing CRL status report for dn: {}", (Object)dn);
            }
            StorageContainerDatanodeProtocolProtos.CRLStatusReport crlStatusReport = (StorageContainerDatanodeProtocolProtos.CRLStatusReport)reportFromDatanode.getReport();
            long receivedCRLId = crlStatusReport.getReceivedCrlId();
            List pendingCRLIds = crlStatusReport.getPendingCrlIdsList();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Updating Processed CRL Id: {} and Pending CRL Ids: {} ", (Object)receivedCRLId, (Object)pendingCRLIds);
            }
            CRLStatus crlStatus = new CRLStatus(receivedCRLId, pendingCRLIds);
            this.certStore.setCRLStatusForDN(dn.getUuid(), crlStatus);
        }
    }
}

