/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.runtime.RemoteControlReader;
import org.jacoco.core.runtime.RemoteControlWriter;

public final class JacocoServer {
    private static Object lockMonitor = new Object();
    private static int port = 6300;
    private static String destinationFile = "/tmp/jacoco-combined.exec";

    private JacocoServer() {
    }

    public static void main(String[] args) throws IOException {
        ExecutionDataWriter destination = new ExecutionDataWriter((OutputStream)new FileOutputStream(destinationFile));
        ServerSocket serverSocket = new ServerSocket(port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                destination.flush();
                serverSocket.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }));
        while (true) {
            Socket socket = serverSocket.accept();
            new Thread(() -> {
                try {
                    RemoteControlWriter writer = new RemoteControlWriter(socket.getOutputStream());
                    RemoteControlReader reader = new RemoteControlReader(socket.getInputStream());
                    reader.setSessionInfoVisitor(JacocoServer.synchronizedCall(arg_0 -> ((ExecutionDataWriter)destination).visitSessionInfo(arg_0)));
                    reader.setExecutionDataVisitor(JacocoServer.synchronizedCall(arg_0 -> ((ExecutionDataWriter)destination).visitClassExecution(arg_0)));
                    while (reader.read()) {
                    }
                    Object object = lockMonitor;
                    synchronized (object) {
                        destination.flush();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public static ISessionInfoVisitor synchronizedCall(ISessionInfoVisitor origin) {
        return data -> {
            Object object = lockMonitor;
            synchronized (object) {
                origin.visitSessionInfo(data);
            }
        };
    }

    public static IExecutionDataVisitor synchronizedCall(IExecutionDataVisitor origin) {
        return data -> {
            Object object = lockMonitor;
            synchronized (object) {
                origin.visitClassExecution(data);
            }
        };
    }
}

