/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.test;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.ozone.test.Log4j1Capturer;
import org.apache.ozone.test.Log4j2Capturer;
import org.apache.ozone.test.TimedOutTestsListener;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import org.slf4j.Logger;

public abstract class GenericTestUtils {
    public static final String SYSPROP_TEST_DATA_DIR = "test.build.data";
    public static final String DEFAULT_TEST_DATA_DIR;
    public static final String DEFAULT_TEST_DATA_PATH = "target/test/data/";
    public static final String ERROR_MISSING_ARGUMENT = "Input supplier interface should be initialized";
    public static final String ERROR_INVALID_ARGUMENT = "Total wait time should be greater than check interval time";
    public static final boolean WINDOWS;
    private static final long NANOSECONDS_PER_MILLISECOND = 1000000L;

    public static File getTestDir() {
        String prop = System.getProperty(SYSPROP_TEST_DATA_DIR, DEFAULT_TEST_DATA_DIR);
        if (prop.isEmpty()) {
            prop = DEFAULT_TEST_DATA_DIR;
        }
        File dir = new File(prop).getAbsoluteFile();
        GenericTestUtils.assertDirCreation(dir);
        return dir;
    }

    public static File getTestDir(String subdir) {
        return new File(GenericTestUtils.getTestDir(), subdir).getAbsoluteFile();
    }

    public static File getRandomizedTestDir() {
        return new File(GenericTestUtils.getRandomizedTempPath());
    }

    public static String getTempPath(String subpath) {
        String prop;
        String string = prop = WINDOWS ? DEFAULT_TEST_DATA_PATH : System.getProperty(SYSPROP_TEST_DATA_DIR, DEFAULT_TEST_DATA_PATH);
        if (prop.isEmpty()) {
            prop = DEFAULT_TEST_DATA_PATH;
        }
        if (!prop.endsWith("/")) {
            prop = prop + "/";
        }
        return prop + subpath;
    }

    public static String getRandomizedTempPath() {
        return GenericTestUtils.getTempPath(StackLocatorUtil.getCallerClass(GenericTestUtils.class).getSimpleName() + "-" + RandomStringUtils.randomAlphanumeric((int)10));
    }

    public static void assertExists(File f) {
        Assertions.assertTrue((boolean)f.exists(), (String)("File " + f + " should exist"));
    }

    public static void assertDirCreation(File f) {
        Assertions.assertTrue((f.mkdirs() || f.exists() ? 1 : 0) != 0, (String)("Could not create dir " + f + ", nor does it exist"));
    }

    public static void assertExceptionContains(String expectedText, Throwable t) {
        GenericTestUtils.assertExceptionContains(expectedText, t, "");
    }

    public static void assertExceptionContains(String expectedText, Throwable t, String message) {
        Assertions.assertNotNull((Object)t, (String)"Null Throwable");
        String msg = t.toString();
        if (msg == null) {
            throw new AssertionError("Null Throwable.toString() value", t);
        }
        if (expectedText != null && !msg.contains(expectedText)) {
            String prefix = StringUtils.isEmpty((CharSequence)message) ? "" : message + ": ";
            throw new AssertionError(String.format("%s Expected to find '%s' %s: %s", prefix, expectedText, "but got unexpected exception", GenericTestUtils.stringifyException(t)), t);
        }
    }

    public static String stringifyException(Throwable e) {
        StringWriter stm = new StringWriter();
        PrintWriter wrt = new PrintWriter(stm);
        e.printStackTrace(wrt);
        wrt.close();
        return stm.toString();
    }

    public static void waitFor(BooleanSupplier check, int checkEveryMillis, int waitForMillis) throws TimeoutException, InterruptedException {
        Preconditions.checkNotNull((Object)check, (Object)ERROR_MISSING_ARGUMENT);
        Preconditions.checkArgument((waitForMillis >= checkEveryMillis ? 1 : 0) != 0, (Object)ERROR_INVALID_ARGUMENT);
        long st = GenericTestUtils.monotonicNow();
        boolean result = check.getAsBoolean();
        while (!result && GenericTestUtils.monotonicNow() - st < (long)waitForMillis) {
            Thread.sleep(checkEveryMillis);
            result = check.getAsBoolean();
        }
        if (!result) {
            throw new TimeoutException("Timed out waiting for condition. Thread diagnostics:\n" + TimedOutTestsListener.buildThreadDiagnosticString());
        }
    }

    @Deprecated
    public static void setLogLevel(org.apache.log4j.Logger logger, Level level) {
        logger.setLevel(level);
    }

    public static void setLogLevel(Logger logger, org.slf4j.event.Level level) {
        GenericTestUtils.setLogLevel(GenericTestUtils.toLog4j(logger), Level.toLevel((String)level.toString()));
    }

    public static void setRootLogLevel(org.slf4j.event.Level level) {
        GenericTestUtils.setLogLevel(LogManager.getRootLogger(), Level.toLevel((String)level.toString()));
    }

    public static <T> T mockFieldReflection(Object object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = object.getClass().getDeclaredField(fieldName);
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        boolean modifierFieldAccessible = modifiersField.isAccessible();
        modifiersField.setAccessible(true);
        int modifierVal = modifiersField.getInt(field);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        Object value = field.get(object);
        value = Mockito.spy((Object)value);
        field.set(object, value);
        modifiersField.setInt(field, modifierVal);
        modifiersField.setAccessible(modifierFieldAccessible);
        field.setAccessible(isAccessible);
        return (T)value;
    }

    public static <T> T getFieldReflection(Object object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = object.getClass().getDeclaredField(fieldName);
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        boolean modifierFieldAccessible = modifiersField.isAccessible();
        modifiersField.setAccessible(true);
        int modifierVal = modifiersField.getInt(field);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        Object value = field.get(object);
        modifiersField.setInt(field, modifierVal);
        modifiersField.setAccessible(modifierFieldAccessible);
        field.setAccessible(isAccessible);
        return (T)value;
    }

    public static <K, V> Map<V, K> getReverseMap(Map<K, List<V>> map) {
        return map.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(v -> Pair.of((Object)v, entry.getKey()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public static boolean deleteDirectory(File dir) {
        File[] allContents = dir.listFiles();
        if (allContents != null) {
            for (File content : allContents) {
                if (GenericTestUtils.deleteDirectory(content)) continue;
                return false;
            }
        }
        return dir.delete();
    }

    @Deprecated
    public static org.apache.log4j.Logger toLog4j(Logger logger) {
        return LogManager.getLogger((String)logger.getName());
    }

    private static long monotonicNow() {
        return System.nanoTime() / 1000000L;
    }

    static {
        WINDOWS = System.getProperty("os.name").startsWith("Windows");
        DEFAULT_TEST_DATA_DIR = "target" + File.separator + "test" + File.separator + "data";
    }

    public static class TeePrintStream
    extends PrintStream {
        private final PrintStream other;

        public TeePrintStream(OutputStream main, PrintStream other) throws UnsupportedEncodingException {
            super(main, false, StandardCharsets.UTF_8.name());
            this.other = other;
        }

        @Override
        public void flush() {
            super.flush();
            this.other.flush();
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            super.write(buf, off, len);
            this.other.write(buf, off, len);
        }
    }

    public static class SystemOutCapturer
    implements AutoCloseable {
        private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        private final PrintStream bytesPrintStream = new PrintStream((OutputStream)this.bytes, false, StandardCharsets.UTF_8.name());
        private final PrintStream oldOut = System.out;

        public SystemOutCapturer() throws UnsupportedEncodingException {
            System.setOut(new TeePrintStream((OutputStream)this.oldOut, this.bytesPrintStream));
        }

        public String getOutput() throws UnsupportedEncodingException {
            return this.bytes.toString(StandardCharsets.UTF_8.name());
        }

        @Override
        public void close() throws Exception {
            IOUtils.closeQuietly((OutputStream)this.bytesPrintStream);
            System.setOut(this.oldOut);
        }
    }

    public static class SystemErrCapturer
    implements AutoCloseable {
        private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        private final PrintStream bytesPrintStream = new PrintStream((OutputStream)this.bytes, false, StandardCharsets.UTF_8.name());
        private final PrintStream oldErr = System.err;

        public SystemErrCapturer() throws UnsupportedEncodingException {
            System.setErr(new TeePrintStream((OutputStream)this.oldErr, this.bytesPrintStream));
        }

        public String getOutput() throws UnsupportedEncodingException {
            return this.bytes.toString(StandardCharsets.UTF_8.name());
        }

        @Override
        public void close() throws Exception {
            IOUtils.closeQuietly((OutputStream)this.bytesPrintStream);
            System.setErr(this.oldErr);
        }
    }

    public static abstract class LogCapturer {
        private final StringWriter sw = new StringWriter();

        public static LogCapturer captureLogs(org.apache.log4j.Logger logger) {
            return new Log4j1Capturer(logger);
        }

        public static LogCapturer captureLogs(org.apache.log4j.Logger logger, Layout layout) {
            return new Log4j1Capturer(logger, layout);
        }

        public static LogCapturer captureLogs(Logger logger) {
            return new Log4j1Capturer(GenericTestUtils.toLog4j(logger));
        }

        public static LogCapturer log4j2(String ignoredLoggerName) {
            return Log4j2Capturer.getInstance();
        }

        public String getOutput() {
            return this.writer().toString();
        }

        public abstract void stopCapturing();

        protected StringWriter writer() {
            return this.sw;
        }

        public void clearOutput() {
            this.writer().getBuffer().setLength(0);
        }
    }
}

