/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.test;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LambdaTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LambdaTestUtils.class);
    public static final String NULL_RESULT = "(null)";

    private LambdaTestUtils() {
    }

    public static int await(int timeoutMillis, Callable<Boolean> check, Callable<Integer> retry, TimeoutHandler timeoutHandler) throws Exception {
        Throwable evaluate;
        Preconditions.checkArgument((timeoutMillis >= 0 ? 1 : 0) != 0, (Object)"timeoutMillis must be >= 0");
        Preconditions.checkNotNull((Object)timeoutHandler);
        long endTime = System.currentTimeMillis() + (long)timeoutMillis;
        Throwable ex = null;
        boolean running = true;
        int iterations = 0;
        while (running) {
            ++iterations;
            try {
                if (check.call().booleanValue()) {
                    return iterations;
                }
                ex = null;
            }
            catch (InterruptedException | VirtualMachineError | FailFastException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.debug("await() iteration {}", (Object)iterations, (Object)e);
                ex = e;
            }
            if (!(running = System.currentTimeMillis() < endTime)) continue;
            int sleeptime = retry.call();
            if (sleeptime >= 0) {
                Thread.sleep(sleeptime);
                continue;
            }
            running = false;
        }
        try {
            evaluate = timeoutHandler.evaluate(timeoutMillis, ex);
            if (evaluate == null) {
                LOG.error("timeout handler {} did not throw an exception ", (Object)timeoutHandler);
                evaluate = new GenerateTimeout().evaluate(timeoutMillis, ex);
            }
        }
        catch (Throwable throwable) {
            evaluate = throwable;
        }
        return (Integer)LambdaTestUtils.raise(evaluate);
    }

    public static int await(int timeoutMillis, int intervalMillis, Callable<Boolean> check) throws Exception {
        return LambdaTestUtils.await(timeoutMillis, check, new FixedRetryInterval(intervalMillis), new GenerateTimeout());
    }

    private static <T> T raise(Throwable throwable) throws Exception {
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        throw (Error)throwable;
    }

    private static String robustToString(Object o) {
        if (o == null) {
            return NULL_RESULT;
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            LOG.info("Exception calling toString()", (Throwable)e);
            return o.getClass().toString();
        }
    }

    public static <T> T eval(Callable<T> closure) {
        try {
            return closure.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError(e.toString(), e);
        }
    }

    public static void eval(VoidCallable closure) {
        try {
            closure.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError(e.toString(), e);
        }
    }

    @FunctionalInterface
    public static interface VoidCallable {
        public void call() throws Exception;
    }

    public static class FailFastException
    extends Exception {
        public FailFastException(String detailMessage) {
            super(detailMessage);
        }

        public FailFastException(String message, Throwable cause) {
            super(message, cause);
        }

        public static FailFastException newInstance(String format, Object ... args) {
            return new FailFastException(String.format(format, args));
        }
    }

    public static class FixedRetryInterval
    implements Callable<Integer> {
        private final int intervalMillis;
        private int invocationCount = 0;

        public FixedRetryInterval(int intervalMillis) {
            Preconditions.checkArgument((intervalMillis > 0 ? 1 : 0) != 0);
            this.intervalMillis = intervalMillis;
        }

        @Override
        public Integer call() throws Exception {
            ++this.invocationCount;
            return this.intervalMillis;
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("FixedRetryInterval{");
            sb.append("interval=").append(this.intervalMillis);
            sb.append(", invocationCount=").append(this.invocationCount);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class GenerateTimeout
    implements TimeoutHandler {
        private final String message;

        public GenerateTimeout(String message) {
            this.message = message;
        }

        public GenerateTimeout() {
            this("timeout");
        }

        @Override
        public Throwable evaluate(int timeoutMillis, Throwable caught) {
            String s = String.format("%s: after %d millis", this.message, timeoutMillis);
            String caughtText = caught != null ? "; " + LambdaTestUtils.robustToString(caught) : "";
            return new TimeoutException(s + caughtText).initCause(caught);
        }
    }

    @FunctionalInterface
    public static interface TimeoutHandler {
        public Throwable evaluate(int var1, Throwable var2) throws Throwable;
    }
}

