/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.test;

import java.io.Writer;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.ozone.test.GenericTestUtils;

class Log4j1Capturer
extends GenericTestUtils.LogCapturer {
    private final Appender appender;
    private final Logger logger;

    private static Layout getDefaultLayout() {
        Logger rootLogger = Logger.getRootLogger();
        Appender defaultAppender = rootLogger.getAppender("stdout");
        if (defaultAppender == null) {
            defaultAppender = rootLogger.getAppender("console");
        }
        return defaultAppender == null ? new PatternLayout() : defaultAppender.getLayout();
    }

    Log4j1Capturer(Logger logger) {
        this(logger, Log4j1Capturer.getDefaultLayout());
    }

    Log4j1Capturer(Logger logger, Layout layout) {
        this.logger = logger;
        this.appender = new WriterAppender(layout, (Writer)this.writer());
        logger.addAppender(this.appender);
    }

    @Override
    public void stopCapturing() {
        this.logger.removeAppender(this.appender);
    }
}

