/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.test;

import java.io.Writer;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.ozone.test.GenericTestUtils;

final class Log4j2Capturer
extends GenericTestUtils.LogCapturer {
    private static final String APPENDER_NAME = "capture";
    private static final Log4j2Capturer INSTANCE = new Log4j2Capturer();

    public static Log4j2Capturer getInstance() {
        return INSTANCE;
    }

    private Log4j2Capturer() {
        this.addAppender(this.writer());
    }

    @Override
    public void stopCapturing() {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        this.removeAppender(config);
    }

    private void addAppender(Writer writer) {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        PatternLayout layout = PatternLayout.createDefaultLayout((Configuration)config);
        WriterAppender appender = WriterAppender.createAppender((StringLayout)layout, null, (Writer)writer, (String)APPENDER_NAME, (boolean)false, (boolean)true);
        appender.start();
        config.addAppender((Appender)appender);
        this.addAppender((Appender)appender, config);
    }

    private void addAppender(Appender appender, Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            loggerConfig.addAppender(appender, null, null);
        }
        config.getRootLogger().addAppender(appender, null, null);
    }

    private void removeAppender(Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            loggerConfig.removeAppender(APPENDER_NAME);
        }
        config.getRootLogger().removeAppender(APPENDER_NAME);
    }
}

