/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.test;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAmount;

public class TestClock
extends Clock {
    private Instant instant;
    private final ZoneId zoneId;

    public static TestClock newInstance() {
        return new TestClock(Instant.now(), ZoneOffset.UTC);
    }

    public TestClock(Instant instant, ZoneId zone) {
        this.instant = instant;
        this.zoneId = zone;
    }

    @Override
    public ZoneId getZone() {
        return this.zoneId;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return new TestClock(Instant.now(), zone);
    }

    @Override
    public Instant instant() {
        return this.instant;
    }

    public void fastForward(long millis) {
        this.set(this.instant().plusMillis(millis));
    }

    public void fastForward(TemporalAmount temporalAmount) {
        this.set(this.instant().plus(temporalAmount));
    }

    public void rewind(long millis) {
        this.set(this.instant().minusMillis(millis));
    }

    public void rewind(TemporalAmount temporalAmount) {
        this.set(this.instant().minus(temporalAmount));
    }

    public void set(Instant newInstant) {
        this.instant = newInstant;
    }
}

