/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections.ListUtils;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;

public class OzoneVolume
extends WithMetadata {
    private final ClientProtocol proxy;
    private final String name;
    private String admin;
    private String owner;
    private long quotaInBytes;
    private long quotaInNamespace;
    private long usedNamespace;
    private Instant creationTime;
    private Instant modificationTime;
    private List<OzoneAcl> acls;
    private int listCacheSize;
    private OzoneObj ozoneObj;

    public OzoneVolume(ConfigurationSource conf, ClientProtocol proxy, String name, String admin, String owner, long quotaInBytes, long quotaInNamespace, long creationTime, List<OzoneAcl> acls, Map<String, String> metadata) {
        Preconditions.checkNotNull((Object)proxy, (Object)"Client proxy is not set.");
        this.proxy = proxy;
        this.name = name;
        this.admin = admin;
        this.owner = owner;
        this.quotaInBytes = quotaInBytes;
        this.quotaInNamespace = quotaInNamespace;
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.acls = acls;
        this.listCacheSize = HddsClientUtils.getListCacheSize((ConfigurationSource)conf);
        this.metadata = metadata;
        this.modificationTime = Instant.now();
        if (this.modificationTime.isBefore(this.creationTime)) {
            this.modificationTime = Instant.ofEpochSecond(this.creationTime.getEpochSecond(), this.creationTime.getNano());
        }
        this.ozoneObj = OzoneObjInfo.Builder.newBuilder().setVolumeName(name).setResType(OzoneObj.ResourceType.VOLUME).setStoreType(OzoneObj.StoreType.OZONE).build();
    }

    public OzoneVolume(ConfigurationSource conf, ClientProtocol proxy, String name, String admin, String owner, long quotaInBytes, long quotaInNamespace, long usedNamespace, long creationTime, long modificationTime, List<OzoneAcl> acls, Map<String, String> metadata) {
        this(conf, proxy, name, admin, owner, quotaInBytes, quotaInNamespace, creationTime, acls, metadata);
        this.modificationTime = Instant.ofEpochMilli(modificationTime);
        this.usedNamespace = usedNamespace;
    }

    public OzoneVolume(ConfigurationSource conf, ClientProtocol proxy, String name, String admin, String owner, long quotaInBytes, long quotaInNamespace, long creationTime, List<OzoneAcl> acls) {
        this(conf, proxy, name, admin, owner, quotaInBytes, quotaInNamespace, creationTime, acls, new HashMap<String, String>());
        this.modificationTime = Instant.now();
        if (this.modificationTime.isBefore(this.creationTime)) {
            this.modificationTime = Instant.ofEpochSecond(this.creationTime.getEpochSecond(), this.creationTime.getNano());
        }
    }

    public OzoneVolume(ConfigurationSource conf, ClientProtocol proxy, String name, String admin, String owner, long quotaInBytes, long quotaInNamespace, long usedNamespace, long creationTime, long modificationTime, List<OzoneAcl> acls) {
        this(conf, proxy, name, admin, owner, quotaInBytes, quotaInNamespace, creationTime, acls);
        this.modificationTime = Instant.ofEpochMilli(modificationTime);
        this.usedNamespace = usedNamespace;
    }

    @VisibleForTesting
    protected OzoneVolume(String name, String admin, String owner, long quotaInBytes, long quotaInNamespace, long creationTime, List<OzoneAcl> acls) {
        this.proxy = null;
        this.name = name;
        this.admin = admin;
        this.owner = owner;
        this.quotaInBytes = quotaInBytes;
        this.quotaInNamespace = quotaInNamespace;
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.acls = acls;
        this.metadata = new HashMap();
        this.modificationTime = Instant.now();
        if (this.modificationTime.isBefore(this.creationTime)) {
            this.modificationTime = Instant.ofEpochSecond(this.creationTime.getEpochSecond(), this.creationTime.getNano());
        }
    }

    @VisibleForTesting
    protected OzoneVolume(String name, String admin, String owner, long quotaInBytes, long quotaInNamespace, long creationTime, long modificationTime, List<OzoneAcl> acls) {
        this(name, admin, owner, quotaInBytes, quotaInNamespace, creationTime, acls);
        this.modificationTime = Instant.ofEpochMilli(modificationTime);
    }

    public String getName() {
        return this.name;
    }

    public String getAdmin() {
        return this.admin;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    public List<OzoneAcl> getAcls() {
        return ListUtils.unmodifiableList(this.acls);
    }

    public boolean addAcl(OzoneAcl addAcl) throws IOException {
        boolean added = this.proxy.addAcl(this.ozoneObj, addAcl);
        if (added) {
            this.acls.add(addAcl);
        }
        return added;
    }

    public boolean removeAcl(OzoneAcl acl) throws IOException {
        boolean removed = this.proxy.removeAcl(this.ozoneObj, acl);
        if (removed) {
            this.acls.remove(acl);
        }
        return removed;
    }

    public boolean setAcl(List<OzoneAcl> aclList) throws IOException {
        boolean reset = this.proxy.setAcl(this.ozoneObj, aclList);
        if (reset) {
            this.acls.clear();
            this.acls.addAll(aclList);
        }
        return reset;
    }

    public long getUsedNamespace() {
        return this.usedNamespace;
    }

    public boolean setOwner(String userName) throws IOException {
        boolean result = this.proxy.setVolumeOwner(this.name, userName);
        this.owner = userName;
        return result;
    }

    public void clearSpaceQuota() throws IOException {
        OzoneVolume ozoneVolume = this.proxy.getVolumeDetails(this.name);
        this.proxy.setVolumeQuota(this.name, ozoneVolume.getQuotaInNamespace(), -1L);
        this.quotaInBytes = -1L;
        this.quotaInNamespace = ozoneVolume.getQuotaInNamespace();
    }

    public void clearNamespaceQuota() throws IOException {
        OzoneVolume ozoneVolume = this.proxy.getVolumeDetails(this.name);
        this.proxy.setVolumeQuota(this.name, -1L, ozoneVolume.getQuotaInBytes());
        this.quotaInBytes = ozoneVolume.getQuotaInBytes();
        this.quotaInNamespace = -1L;
    }

    public void setQuota(OzoneQuota quota) throws IOException {
        this.proxy.setVolumeQuota(this.name, quota.getQuotaInNamespace(), quota.getQuotaInBytes());
        this.quotaInBytes = quota.getQuotaInBytes();
        this.quotaInNamespace = quota.getQuotaInNamespace();
    }

    public void createBucket(String bucketName) throws IOException {
        this.proxy.createBucket(this.name, bucketName);
    }

    public void createBucket(String bucketName, BucketArgs bucketArgs) throws IOException {
        this.proxy.createBucket(this.name, bucketName, bucketArgs);
    }

    public OzoneBucket getBucket(String bucketName) throws IOException {
        OzoneBucket bucket = this.proxy.getBucketDetails(this.name, bucketName);
        return bucket;
    }

    public Iterator<? extends OzoneBucket> listBuckets(String bucketPrefix) {
        return this.listBuckets(bucketPrefix, null);
    }

    public Iterator<? extends OzoneBucket> listBuckets(String bucketPrefix, String prevBucket) {
        return new BucketIterator(bucketPrefix, prevBucket);
    }

    public void deleteBucket(String bucketName) throws IOException {
        this.proxy.deleteBucket(this.name, bucketName);
    }

    private class BucketIterator
    implements Iterator<OzoneBucket> {
        private String bucketPrefix = null;
        private Iterator<OzoneBucket> currentIterator;
        private OzoneBucket currentValue;

        BucketIterator(String bucketPrefix, String prevBucket) {
            this.bucketPrefix = bucketPrefix;
            this.currentValue = null;
            this.currentIterator = this.getNextListOfBuckets(prevBucket).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext() && this.currentValue != null) {
                this.currentIterator = this.getNextListOfBuckets(this.currentValue.getName()).iterator();
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneBucket next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        private List<OzoneBucket> getNextListOfBuckets(String prevBucket) {
            try {
                return OzoneVolume.this.proxy.listBuckets(OzoneVolume.this.name, this.bucketPrefix, prevBucket, OzoneVolume.this.listCacheSize);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

