/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.ozone.client.io.OzoneCryptoInputStream;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartCryptoKeyInputStream
extends OzoneInputStream
implements Seekable,
CanUnbuffer {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartCryptoKeyInputStream.class);
    private static final int EOF = -1;
    private String key;
    private long length = 0L;
    private boolean closed = false;
    private List<OzoneCryptoInputStream> partStreams;
    private long[] partOffsets;
    private int partIndex = 0;
    private int prevPartIndex = 0;
    private int readPositionAdjustedBy = 0;
    private int readLengthAdjustedBy = 0;

    public MultipartCryptoKeyInputStream(String keyName, List<OzoneCryptoInputStream> inputStreams) {
        Preconditions.checkNotNull(inputStreams);
        this.key = keyName;
        this.partStreams = inputStreams;
        this.partOffsets = new long[inputStreams.size()];
        int i = 0;
        for (OzoneCryptoInputStream ozoneCryptoInputStream : inputStreams) {
            this.partOffsets[i++] = this.length;
            this.length += ozoneCryptoInputStream.getLength();
        }
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        if (this.read(buf, 0, 1) == -1) {
            return -1;
        }
        return Byte.toUnsignedInt(buf[0]);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkOpen();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int totalReadLen = 0;
        while (len > 0) {
            int numBytesRead;
            if (this.partStreams.size() == 0 || this.partStreams.size() - 1 <= this.partIndex && this.partStreams.get(this.partIndex).getRemaining() == 0L) {
                return totalReadLen == 0 ? -1 : totalReadLen;
            }
            OzoneCryptoInputStream current = this.partStreams.get(this.partIndex);
            int numBytesToRead = this.getNumBytesToRead(len, (int)current.getRemaining(), current.getBufferSize());
            if (this.readPositionAdjustedBy != 0 || this.readLengthAdjustedBy != 0) {
                byte[] tempBuffer = new byte[numBytesToRead];
                int actualNumBytesRead = current.read(tempBuffer, 0, numBytesToRead);
                numBytesRead = actualNumBytesRead - this.readPositionAdjustedBy - this.readLengthAdjustedBy;
                if (actualNumBytesRead != numBytesToRead) {
                    throw new IOException(String.format("Inconsistent read for key=%s part=%d length=%d numBytesToRead(accounting for Crypto boundaries)=%d numBytesRead(actual)=%d numBytesToBeRead(into client buffer discarding crypto boundary adjustments)=%d", this.key, this.partIndex, current.getLength(), numBytesToRead, actualNumBytesRead, numBytesRead));
                }
                System.arraycopy(tempBuffer, this.readPositionAdjustedBy, b, off, numBytesRead);
                LOG.debug("OzoneCryptoInputStream for key: {} part: {} read {} bytes instead of {} bytes to account for Crypto buffer boundary. Client buffer will be copied with read data from position {}upto position {}, discarding the extra bytes read to maintain Crypto buffer boundary limits", new Object[]{this.key, this.partIndex, actualNumBytesRead, numBytesRead, this.readPositionAdjustedBy, actualNumBytesRead - this.readPositionAdjustedBy});
                this.readPositionAdjustedBy = 0;
                this.readLengthAdjustedBy = 0;
            } else {
                numBytesRead = current.read(b, off, numBytesToRead);
                if (numBytesRead != numBytesToRead) {
                    throw new IOException(String.format("Inconsistent read for key=%s part=%d length=%d numBytesToRead=%d numBytesRead=%d", this.key, this.partIndex, current.getLength(), numBytesToRead, numBytesRead));
                }
            }
            totalReadLen += numBytesRead;
            off += numBytesRead;
            len -= numBytesRead;
            if (current.getRemaining() > 0L || this.partIndex + 1 >= this.partStreams.size()) continue;
            ++this.partIndex;
        }
        return totalReadLen;
    }

    private int getNumBytesToRead(int lenToRead, int remaining, int cryptoBufferSize) throws IOException {
        Preconditions.checkArgument((this.readPositionAdjustedBy == 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.readLengthAdjustedBy == 0 ? 1 : 0) != 0);
        this.adjustReadPosition(cryptoBufferSize);
        return this.adjustNumBytesToRead(lenToRead += this.readPositionAdjustedBy, remaining += this.readPositionAdjustedBy, cryptoBufferSize);
    }

    private void adjustReadPosition(long cryptoBufferSize) throws IOException {
        long currentPosOfStream = this.partStreams.get(this.partIndex).getPos();
        int modulus = (int)(currentPosOfStream % cryptoBufferSize);
        if (modulus != 0) {
            this.readPositionAdjustedBy = modulus;
            this.partStreams.get(this.partIndex).seek(currentPosOfStream - (long)this.readPositionAdjustedBy);
            LOG.debug("OzoneCryptoInputStream for key: {} part: {} adjusted position {} by -{} to account for Crypto buffer boundary", new Object[]{this.key, this.partIndex, currentPosOfStream, this.readPositionAdjustedBy});
        }
    }

    private int adjustNumBytesToRead(int lenToRead, int remaining, int cryptoBufferSize) {
        int numBytesToRead = Math.min(cryptoBufferSize, remaining);
        if (lenToRead < numBytesToRead) {
            this.readLengthAdjustedBy = numBytesToRead - lenToRead;
            LOG.debug("OzoneCryptoInputStream for key: {} part: {} adjusted length by +{} to account for Crypto buffer boundary", new Object[]{this.key, this.partIndex, this.readLengthAdjustedBy});
        }
        return numBytesToRead;
    }

    public void seek(long pos) throws IOException {
        if (pos == 0L && this.length == 0L) {
            return;
        }
        if (pos < 0L || pos > this.length) {
            throw new EOFException("EOF encountered at pos: " + pos);
        }
        if (this.partIndex >= this.partStreams.size()) {
            this.partIndex = Arrays.binarySearch(this.partOffsets, pos);
        } else if (pos < this.partOffsets[this.partIndex]) {
            this.partIndex = Arrays.binarySearch(this.partOffsets, 0, this.partIndex, pos);
        } else if (pos >= this.partOffsets[this.partIndex] + this.partStreams.get(this.partIndex).getLength()) {
            this.partIndex = Arrays.binarySearch(this.partOffsets, this.partIndex + 1, this.partStreams.size(), pos);
        }
        if (this.partIndex < 0) {
            this.partIndex = -this.partIndex - 2;
        }
        this.partStreams.get(this.prevPartIndex).seek(0L);
        for (int index = this.partIndex + 1; index < this.partStreams.size(); ++index) {
            this.partStreams.get(index).seek(0L);
        }
        this.partStreams.get(this.partIndex).seek(pos - this.partOffsets[this.partIndex]);
        this.prevPartIndex = this.partIndex;
    }

    public synchronized long getPos() throws IOException {
        this.checkOpen();
        return this.length == 0L ? 0L : this.partOffsets[this.partIndex] + this.partStreams.get(this.partIndex).getPos();
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    @Override
    public int available() throws IOException {
        this.checkOpen();
        long remaining = this.length - this.getPos();
        return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
    }

    @Override
    public void unbuffer() {
        for (CryptoInputStream cryptoInputStream : this.partStreams) {
            cryptoInputStream.unbuffer();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long toSkip = Math.min(n, this.length - this.getPos());
        this.seek(this.getPos() + toSkip);
        return toSkip;
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        for (OzoneCryptoInputStream partStream : this.partStreams) {
            partStream.close();
        }
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException(": Stream is closed! Key: " + this.key);
        }
    }
}

