/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.crypto.CryptoStreamUtils;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.ozone.client.io.LengthInputStream;

public class OzoneCryptoInputStream
extends CryptoInputStream
implements Seekable {
    private final long length;
    private final int bufferSize;

    public OzoneCryptoInputStream(LengthInputStream in, CryptoCodec codec, byte[] key, byte[] iv) throws IOException {
        super(in.getWrappedStream(), codec, key, iv);
        this.length = in.getLength();
        this.bufferSize = CryptoStreamUtils.getBufferSize((Configuration)codec.getConf());
    }

    public long getLength() {
        return this.length;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public long getRemaining() throws IOException {
        return this.length - this.getPos();
    }
}

