/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.TenantArgs;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.DeleteTenantState;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.S3VolumeContext;
import org.apache.hadoop.ozone.om.helpers.TenantStateList;
import org.apache.hadoop.ozone.om.helpers.TenantUserInfoValue;
import org.apache.hadoop.ozone.om.helpers.TenantUserList;
import org.apache.hadoop.ozone.om.protocol.S3Auth;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStore {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStore.class);
    private final ConfigurationSource conf;
    private final ClientProtocol proxy;
    private int listCacheSize;
    private final String defaultS3Volume;

    public ObjectStore(ConfigurationSource conf, ClientProtocol proxy) {
        this.conf = conf;
        this.proxy = (ClientProtocol)TracingUtil.createProxy((Object)proxy, ClientProtocol.class, (ConfigurationSource)conf);
        this.listCacheSize = HddsClientUtils.getListCacheSize((ConfigurationSource)conf);
        this.defaultS3Volume = HddsClientUtils.getDefaultS3VolumeName((ConfigurationSource)conf);
    }

    @VisibleForTesting
    protected ObjectStore() {
        this.conf = new OzoneConfiguration();
        this.proxy = null;
        this.defaultS3Volume = HddsClientUtils.getDefaultS3VolumeName((ConfigurationSource)this.conf);
    }

    @VisibleForTesting
    public ClientProtocol getClientProxy() {
        return this.proxy;
    }

    public void createVolume(String volumeName) throws IOException {
        this.proxy.createVolume(volumeName);
    }

    public void createVolume(String volumeName, VolumeArgs volumeArgs) throws IOException {
        this.proxy.createVolume(volumeName, volumeArgs);
    }

    public void createS3Bucket(String bucketName) throws IOException {
        OzoneVolume volume = this.getS3Volume();
        volume.createBucket(bucketName);
    }

    public OzoneBucket getS3Bucket(String bucketName) throws IOException {
        return this.getS3Volume().getBucket(bucketName);
    }

    public void deleteS3Bucket(String bucketName) throws IOException {
        try {
            OzoneVolume volume = this.getS3Volume();
            volume.deleteBucket(bucketName);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.VOLUME_NOT_FOUND) {
                throw new OMException(OMException.ResultCodes.BUCKET_NOT_FOUND);
            }
            throw ex;
        }
    }

    public OzoneVolume getVolume(String volumeName) throws IOException {
        return this.proxy.getVolumeDetails(volumeName);
    }

    public OzoneVolume getS3Volume() throws IOException {
        S3VolumeContext resp = this.proxy.getS3VolumeContext();
        S3Auth s3Auth = this.proxy.getThreadLocalS3Auth();
        if (s3Auth != null) {
            LOG.debug("Updating S3Auth.userPrincipal to {}", (Object)resp.getUserPrincipal());
            s3Auth.setUserPrincipal(resp.getUserPrincipal());
            this.proxy.setThreadLocalS3Auth(s3Auth);
        }
        OmVolumeArgs volume = resp.getOmVolumeArgs();
        return this.proxy.buildOzoneVolume(volume);
    }

    public S3VolumeContext getS3VolumeContext() throws IOException {
        return this.proxy.getS3VolumeContext();
    }

    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        return this.proxy.getS3Secret(kerberosID);
    }

    public S3SecretValue getS3Secret(String kerberosID, boolean createIfNotExist) throws IOException {
        return this.proxy.getS3Secret(kerberosID, createIfNotExist);
    }

    public S3SecretValue setS3Secret(String accessId, String secretKey) throws IOException {
        return this.proxy.setS3Secret(accessId, secretKey);
    }

    public void revokeS3Secret(String kerberosID) throws IOException {
        this.proxy.revokeS3Secret(kerberosID);
    }

    public void createTenant(String tenantId) throws IOException {
        this.proxy.createTenant(tenantId);
    }

    public void createTenant(String tenantId, TenantArgs tenantArgs) throws IOException {
        this.proxy.createTenant(tenantId, tenantArgs);
    }

    public DeleteTenantState deleteTenant(String tenantId) throws IOException {
        return this.proxy.deleteTenant(tenantId);
    }

    public S3SecretValue tenantAssignUserAccessId(String username, String tenantId, String accessId) throws IOException {
        return this.proxy.tenantAssignUserAccessId(username, tenantId, accessId);
    }

    public void tenantRevokeUserAccessId(String accessId) throws IOException {
        this.proxy.tenantRevokeUserAccessId(accessId);
    }

    public void tenantAssignAdmin(String accessId, String tenantId, boolean delegated) throws IOException {
        this.proxy.tenantAssignAdmin(accessId, tenantId, delegated);
    }

    public void tenantRevokeAdmin(String accessId, String tenantId) throws IOException {
        this.proxy.tenantRevokeAdmin(accessId, tenantId);
    }

    public TenantUserList listUsersInTenant(String tenantId, String userPrefix) throws IOException {
        return this.proxy.listUsersInTenant(tenantId, userPrefix);
    }

    public TenantUserInfoValue tenantGetUserInfo(String userPrincipal) throws IOException {
        return this.proxy.tenantGetUserInfo(userPrincipal);
    }

    public TenantStateList listTenant() throws IOException {
        return this.proxy.listTenant();
    }

    public Iterator<? extends OzoneVolume> listVolumes(String volumePrefix) throws IOException {
        return this.listVolumes(volumePrefix, null);
    }

    public Iterator<? extends OzoneVolume> listVolumes(String volumePrefix, String prevVolume) throws IOException {
        return new VolumeIterator(null, volumePrefix, prevVolume);
    }

    public Iterator<? extends OzoneVolume> listVolumesByUser(String user, String volumePrefix, String prevVolume) throws IOException {
        if (Strings.isNullOrEmpty((String)user)) {
            user = UserGroupInformation.getCurrentUser().getUserName();
        }
        return new VolumeIterator(user, volumePrefix, prevVolume);
    }

    public void deleteVolume(String volumeName) throws IOException {
        this.proxy.deleteVolume(volumeName);
    }

    public KeyProvider getKeyProvider() throws IOException {
        return this.proxy.getKeyProvider();
    }

    public URI getKeyProviderUri() throws IOException {
        return this.proxy.getKeyProviderUri();
    }

    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.proxy.getDelegationToken(renewer);
    }

    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws IOException {
        return this.proxy.renewDelegationToken(token);
    }

    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws IOException {
        this.proxy.cancelDelegationToken(token);
    }

    public String getCanonicalServiceName() {
        return this.proxy.getCanonicalServiceName();
    }

    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        return this.proxy.addAcl(obj, acl);
    }

    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        return this.proxy.removeAcl(obj, acl);
    }

    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        return this.proxy.setAcl(obj, acls);
    }

    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        return this.proxy.getAcl(obj);
    }

    private class VolumeIterator
    implements Iterator<OzoneVolume> {
        private String user = null;
        private String volPrefix = null;
        private Iterator<OzoneVolume> currentIterator;
        private OzoneVolume currentValue;

        VolumeIterator(String user, String volPrefix, String prevVolume) {
            this.user = user;
            this.volPrefix = volPrefix;
            this.currentValue = null;
            this.currentIterator = this.getNextListOfVolumes(prevVolume).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext() && this.currentValue != null) {
                this.currentIterator = this.getNextListOfVolumes(this.currentValue.getName()).iterator();
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneVolume next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        private List<OzoneVolume> getNextListOfVolumes(String prevVolume) {
            try {
                if (this.user != null) {
                    return ObjectStore.this.proxy.listVolumes(this.user, this.volPrefix, prevVolume, ObjectStore.this.listCacheSize);
                }
                return ObjectStore.this.proxy.listVolumes(this.volPrefix, prevVolume, ObjectStore.this.listCacheSize);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

