/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadList;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadPartListParts;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.util.Time;

public class OzoneBucket
extends WithMetadata {
    private final ClientProtocol proxy;
    private final String volumeName;
    private final String name;
    private ReplicationConfig defaultReplication;
    private StorageType storageType;
    private Boolean versioning;
    private int listCacheSize;
    private long usedBytes;
    private long usedNamespace;
    private Instant creationTime;
    private Instant modificationTime;
    private String encryptionKeyName;
    private OzoneObj ozoneObj;
    private String sourceVolume;
    private String sourceBucket;
    private long quotaInBytes;
    private long quotaInNamespace;
    private BucketLayout bucketLayout = BucketLayout.DEFAULT;
    private String owner;

    private OzoneBucket(ConfigurationSource conf, String volumeName, String bucketName, ClientProtocol proxy) {
        Preconditions.checkNotNull((Object)proxy, (Object)"Client proxy is not set.");
        this.volumeName = volumeName;
        this.name = bucketName;
        this.defaultReplication = null;
        this.proxy = proxy;
        this.ozoneObj = OzoneObjInfo.Builder.newBuilder().setBucketName(bucketName).setVolumeName(volumeName).setResType(OzoneObj.ResourceType.BUCKET).setStoreType(OzoneObj.StoreType.OZONE).build();
    }

    public OzoneBucket(ConfigurationSource conf, ClientProtocol proxy, String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime, Map<String, String> metadata, String encryptionKeyName, String sourceVolume, String sourceBucket) {
        this(conf, volumeName, bucketName, proxy);
        this.storageType = storageType;
        this.versioning = versioning;
        this.listCacheSize = HddsClientUtils.getListCacheSize((ConfigurationSource)conf);
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.metadata = metadata;
        this.encryptionKeyName = encryptionKeyName;
        this.sourceVolume = sourceVolume;
        this.sourceBucket = sourceBucket;
        this.modificationTime = Instant.now();
        if (this.modificationTime.isBefore(this.creationTime)) {
            this.modificationTime = Instant.ofEpochSecond(this.creationTime.getEpochSecond(), this.creationTime.getNano());
        }
    }

    public OzoneBucket(ConfigurationSource conf, ClientProtocol proxy, String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime, long modificationTime, Map<String, String> metadata, String encryptionKeyName, String sourceVolume, String sourceBucket) {
        this(conf, proxy, volumeName, bucketName, storageType, versioning, creationTime, metadata, encryptionKeyName, sourceVolume, sourceBucket);
        this.modificationTime = Instant.ofEpochMilli(modificationTime);
    }

    public OzoneBucket(ConfigurationSource conf, ClientProtocol proxy, String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime, long modificationTime, Map<String, String> metadata, String encryptionKeyName, String sourceVolume, String sourceBucket, long usedBytes, long usedNamespace, long quotaInBytes, long quotaInNamespace) {
        this(conf, proxy, volumeName, bucketName, storageType, versioning, creationTime, metadata, encryptionKeyName, sourceVolume, sourceBucket);
        this.usedBytes = usedBytes;
        this.usedNamespace = usedNamespace;
        this.modificationTime = Instant.ofEpochMilli(modificationTime);
        this.quotaInBytes = quotaInBytes;
        this.quotaInNamespace = quotaInNamespace;
    }

    public OzoneBucket(ConfigurationSource conf, ClientProtocol proxy, String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime, long modificationTime, Map<String, String> metadata, String encryptionKeyName, String sourceVolume, String sourceBucket, long usedBytes, long usedNamespace, long quotaInBytes, long quotaInNamespace, BucketLayout bucketLayout) {
        this(conf, proxy, volumeName, bucketName, storageType, versioning, creationTime, modificationTime, metadata, encryptionKeyName, sourceVolume, sourceBucket, usedBytes, usedNamespace, quotaInBytes, quotaInNamespace);
        this.bucketLayout = bucketLayout;
    }

    public OzoneBucket(ConfigurationSource conf, ClientProtocol proxy, String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime, long modificationTime, Map<String, String> metadata, String encryptionKeyName, String sourceVolume, String sourceBucket, long usedBytes, long usedNamespace, long quotaInBytes, long quotaInNamespace, BucketLayout bucketLayout, String owner, DefaultReplicationConfig defaultReplicationConfig) {
        this(conf, proxy, volumeName, bucketName, storageType, versioning, creationTime, modificationTime, metadata, encryptionKeyName, sourceVolume, sourceBucket, usedBytes, usedNamespace, quotaInBytes, quotaInNamespace, bucketLayout, owner);
        this.bucketLayout = bucketLayout;
        this.defaultReplication = defaultReplicationConfig != null ? (defaultReplicationConfig.getType() == ReplicationType.EC ? defaultReplicationConfig.getEcReplicationConfig() : ReplicationConfig.fromTypeAndFactor((ReplicationType)defaultReplicationConfig.getType(), (ReplicationFactor)defaultReplicationConfig.getFactor())) : null;
    }

    public OzoneBucket(ConfigurationSource conf, ClientProtocol proxy, String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime, long modificationTime, Map<String, String> metadata, String encryptionKeyName, String sourceVolume, String sourceBucket, long usedBytes, long usedNamespace, long quotaInBytes, long quotaInNamespace, BucketLayout bucketLayout, String owner) {
        this(conf, proxy, volumeName, bucketName, storageType, versioning, creationTime, modificationTime, metadata, encryptionKeyName, sourceVolume, sourceBucket, usedBytes, usedNamespace, quotaInBytes, quotaInNamespace, bucketLayout);
        this.owner = owner;
    }

    public OzoneBucket(ConfigurationSource conf, ClientProtocol proxy, String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime, Map<String, String> metadata) {
        this(conf, volumeName, bucketName, proxy);
        this.storageType = storageType;
        this.versioning = versioning;
        this.listCacheSize = HddsClientUtils.getListCacheSize((ConfigurationSource)conf);
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.metadata = metadata;
        this.modificationTime = Instant.now();
        if (this.modificationTime.isBefore(this.creationTime)) {
            this.modificationTime = Instant.ofEpochSecond(this.creationTime.getEpochSecond(), this.creationTime.getNano());
        }
    }

    public OzoneBucket(ConfigurationSource conf, ClientProtocol proxy, String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime, long modificationTime, Map<String, String> metadata) {
        this(conf, proxy, volumeName, bucketName, storageType, versioning, creationTime, metadata);
        this.modificationTime = Instant.ofEpochMilli(modificationTime);
    }

    @VisibleForTesting
    OzoneBucket(String volumeName, String name, ReplicationConfig defaultReplication, StorageType storageType, Boolean versioning, long creationTime) {
        this.proxy = null;
        this.volumeName = volumeName;
        this.name = name;
        this.defaultReplication = defaultReplication;
        this.storageType = storageType;
        this.versioning = versioning;
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.ozoneObj = OzoneObjInfo.Builder.newBuilder().setBucketName(name).setVolumeName(volumeName).setResType(OzoneObj.ResourceType.BUCKET).setStoreType(OzoneObj.StoreType.OZONE).build();
        long modifiedTime = Time.now();
        this.modificationTime = modifiedTime < creationTime ? Instant.ofEpochMilli(creationTime) : Instant.ofEpochMilli(modifiedTime);
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public List<OzoneAcl> getAcls() throws IOException {
        return this.proxy.getAcl(this.ozoneObj);
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public Boolean getVersioning() {
        return this.versioning;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    public String getEncryptionKeyName() {
        return this.encryptionKeyName;
    }

    public String getSourceVolume() {
        return this.sourceVolume;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean addAcl(OzoneAcl addAcl) throws IOException {
        return this.proxy.addAcl(this.ozoneObj, addAcl);
    }

    public boolean removeAcl(OzoneAcl removeAcl) throws IOException {
        return this.proxy.removeAcl(this.ozoneObj, removeAcl);
    }

    public boolean setAcl(List<OzoneAcl> acls) throws IOException {
        return this.proxy.setAcl(this.ozoneObj, acls);
    }

    public void setStorageType(StorageType newStorageType) throws IOException {
        this.proxy.setBucketStorageType(this.volumeName, this.name, newStorageType);
        this.storageType = newStorageType;
    }

    public void setVersioning(Boolean newVersioning) throws IOException {
        this.proxy.setBucketVersioning(this.volumeName, this.name, newVersioning);
        this.versioning = newVersioning;
    }

    public void clearSpaceQuota() throws IOException {
        OzoneBucket ozoneBucket = this.proxy.getBucketDetails(this.volumeName, this.name);
        this.proxy.setBucketQuota(this.volumeName, this.name, ozoneBucket.getQuotaInNamespace(), -1L);
        this.quotaInBytes = -1L;
        this.quotaInNamespace = ozoneBucket.getQuotaInNamespace();
    }

    public void clearNamespaceQuota() throws IOException {
        OzoneBucket ozoneBucket = this.proxy.getBucketDetails(this.volumeName, this.name);
        this.proxy.setBucketQuota(this.volumeName, this.name, -1L, ozoneBucket.getQuotaInBytes());
        this.quotaInBytes = ozoneBucket.getQuotaInBytes();
        this.quotaInNamespace = -1L;
    }

    public void setQuota(OzoneQuota quota) throws IOException {
        this.proxy.setBucketQuota(this.volumeName, this.name, quota.getQuotaInNamespace(), quota.getQuotaInBytes());
        this.quotaInBytes = quota.getQuotaInBytes();
        this.quotaInNamespace = quota.getQuotaInNamespace();
    }

    public void setReplicationConfig(ReplicationConfig replicationConfig) throws IOException {
        this.proxy.setReplicationConfig(this.volumeName, this.name, replicationConfig);
    }

    public OzoneOutputStream createKey(String key, long size) throws IOException {
        return this.createKey(key, size, this.defaultReplication, new HashMap<String, String>());
    }

    @Deprecated
    public OzoneOutputStream createKey(String key, long size, ReplicationType type, ReplicationFactor factor, Map<String, String> keyMetadata) throws IOException {
        return this.proxy.createKey(this.volumeName, this.name, key, size, type, factor, keyMetadata);
    }

    public OzoneOutputStream createKey(String key, long size, ReplicationConfig replicationConfig, Map<String, String> keyMetadata) throws IOException {
        return this.proxy.createKey(this.volumeName, this.name, key, size, replicationConfig, keyMetadata);
    }

    public OzoneInputStream readKey(String key) throws IOException {
        return this.proxy.getKey(this.volumeName, this.name, key);
    }

    public OzoneKeyDetails getKey(String key) throws IOException {
        return this.proxy.getKeyDetails(this.volumeName, this.name, key);
    }

    public OzoneKey headObject(String key) throws IOException {
        return this.proxy.headObject(this.volumeName, this.name, key);
    }

    public long getUsedBytes() {
        return this.usedBytes;
    }

    public long getUsedNamespace() {
        return this.usedNamespace;
    }

    public Iterator<? extends OzoneKey> listKeys(String keyPrefix) throws IOException {
        return this.listKeys(keyPrefix, null);
    }

    public Iterator<? extends OzoneKey> listKeys(String keyPrefix, String prevKey) throws IOException {
        return new KeyIteratorFactory().getKeyIterator(keyPrefix, prevKey, this.bucketLayout);
    }

    public boolean isLink() {
        return this.sourceVolume != null && this.sourceBucket != null;
    }

    public void deleteKey(String key) throws IOException {
        this.proxy.deleteKey(this.volumeName, this.name, key, false);
    }

    public void deleteDirectory(String key, boolean recursive) throws IOException {
        this.proxy.deleteKey(this.volumeName, this.name, key, recursive);
    }

    public void deleteKeys(List<String> keyList) throws IOException {
        this.proxy.deleteKeys(this.volumeName, this.name, keyList);
    }

    public void renameKey(String fromKeyName, String toKeyName) throws IOException {
        this.proxy.renameKey(this.volumeName, this.name, fromKeyName, toKeyName);
    }

    @Deprecated
    public void renameKeys(Map<String, String> keyMap) throws IOException {
        this.proxy.renameKeys(this.volumeName, this.name, keyMap);
    }

    @Deprecated
    public OmMultipartInfo initiateMultipartUpload(String keyName, ReplicationType type, ReplicationFactor factor) throws IOException {
        return this.proxy.initiateMultipartUpload(this.volumeName, this.name, keyName, type, factor);
    }

    public OmMultipartInfo initiateMultipartUpload(String keyName, ReplicationConfig config) throws IOException {
        return this.proxy.initiateMultipartUpload(this.volumeName, this.name, keyName, config);
    }

    public OmMultipartInfo initiateMultipartUpload(String key) throws IOException {
        return this.initiateMultipartUpload(key, this.defaultReplication);
    }

    public OzoneOutputStream createMultipartKey(String key, long size, int partNumber, String uploadID) throws IOException {
        return this.proxy.createMultipartKey(this.volumeName, this.name, key, size, partNumber, uploadID);
    }

    public OmMultipartUploadCompleteInfo completeMultipartUpload(String key, String uploadID, Map<Integer, String> partsMap) throws IOException {
        return this.proxy.completeMultipartUpload(this.volumeName, this.name, key, uploadID, partsMap);
    }

    public void abortMultipartUpload(String keyName, String uploadID) throws IOException {
        this.proxy.abortMultipartUpload(this.volumeName, this.name, keyName, uploadID);
    }

    public OzoneMultipartUploadPartListParts listParts(String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        return this.proxy.listParts(this.volumeName, this.name, keyName, uploadID, partNumberMarker, maxParts);
    }

    public OzoneFileStatus getFileStatus(String keyName) throws IOException {
        return this.proxy.getOzoneFileStatus(this.volumeName, this.name, keyName);
    }

    public void createDirectory(String keyName) throws IOException {
        this.proxy.createDirectory(this.volumeName, this.name, keyName);
    }

    public OzoneInputStream readFile(String keyName) throws IOException {
        return this.proxy.readFile(this.volumeName, this.name, keyName);
    }

    @Deprecated
    public OzoneOutputStream createFile(String keyName, long size, ReplicationType type, ReplicationFactor factor, boolean overWrite, boolean recursive) throws IOException {
        return this.proxy.createFile(this.volumeName, this.name, keyName, size, type, factor, overWrite, recursive);
    }

    public OzoneOutputStream createFile(String keyName, long size, ReplicationConfig replicationConfig, boolean overWrite, boolean recursive) throws IOException {
        return this.proxy.createFile(this.volumeName, this.name, keyName, size, replicationConfig, overWrite, recursive);
    }

    public List<OzoneFileStatus> listStatus(String keyName, boolean recursive, String startKey, long numEntries) throws IOException {
        return this.proxy.listStatus(this.volumeName, this.name, keyName, recursive, startKey, numEntries);
    }

    public List<OzoneFileStatus> listStatus(String keyName, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefix) throws IOException {
        return this.proxy.listStatus(this.volumeName, this.name, keyName, recursive, startKey, numEntries, allowPartialPrefix);
    }

    public OzoneMultipartUploadList listMultipartUploads(String prefix) throws IOException {
        return this.proxy.listMultipartUploads(this.volumeName, this.getName(), prefix);
    }

    public boolean setOwner(String userName) throws IOException {
        boolean result = this.proxy.setBucketOwner(this.volumeName, this.name, userName);
        this.owner = userName;
        return result;
    }

    public BucketLayout getBucketLayout() {
        return this.bucketLayout;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.defaultReplication;
    }

    private class KeyIteratorFactory {
        private KeyIteratorFactory() {
        }

        KeyIterator getKeyIterator(String keyPrefix, String prevKey, BucketLayout bType) throws IOException {
            if (bType.isFileSystemOptimized()) {
                return new KeyIteratorWithFSO(keyPrefix, prevKey);
            }
            return new KeyIterator(keyPrefix, prevKey);
        }
    }

    private class KeyIteratorWithFSO
    extends KeyIterator {
        private Stack<Pair<String, String>> stack;
        private boolean addedKeyPrefix;
        private String removeStartKey;

        KeyIteratorWithFSO(String keyPrefix, String prevKey) throws IOException {
            super(keyPrefix, prevKey);
            this.removeStartKey = "";
        }

        private void getSeekPathsBetweenKeyPrefixAndStartKey(String keyPrefix, String startKey, List<Pair<String, String>> seekPaths) {
            String parentStartKeyPath = OzoneFSUtils.getParentDir((String)startKey);
            if (StringUtils.isNotBlank((CharSequence)startKey)) {
                if (StringUtils.compare((String)parentStartKeyPath, (String)keyPrefix) >= 0) {
                    seekPaths.add((Pair<String, String>)new ImmutablePair((Object)parentStartKeyPath, (Object)startKey));
                    this.getSeekPathsBetweenKeyPrefixAndStartKey(keyPrefix, parentStartKeyPath, seekPaths);
                } else if (StringUtils.compare((String)startKey, (String)keyPrefix) >= 0) {
                    seekPaths.add((Pair<String, String>)new ImmutablePair((Object)keyPrefix, (Object)startKey));
                }
            }
        }

        @Override
        List<OzoneKey> getNextListOfKeys(String prevKey) throws IOException {
            Pair<String, String> keyPrefixPath;
            if (this.stack == null) {
                this.stack = new Stack();
            }
            if (!this.addedKeyPrefix) {
                prevKey = OmUtils.normalizeKey((String)prevKey, (boolean)true);
                String keyPrefixName = "";
                if (StringUtils.isNotBlank((CharSequence)this.getKeyPrefix())) {
                    keyPrefixName = OmUtils.normalizeKey((String)this.getKeyPrefix(), (boolean)true);
                }
                this.setKeyPrefix(keyPrefixName);
                if (StringUtils.isNotBlank((CharSequence)prevKey)) {
                    if (StringUtils.startsWith((CharSequence)prevKey, (CharSequence)this.getKeyPrefix())) {
                        ArrayList<Pair<String, String>> seekPaths = new ArrayList<Pair<String, String>>();
                        if (StringUtils.isNotBlank((CharSequence)this.getKeyPrefix())) {
                            this.addPrevDirectoryToSeekPath(prevKey, seekPaths);
                        }
                        this.removeStartKey = prevKey;
                        this.getSeekPathsBetweenKeyPrefixAndStartKey(this.getKeyPrefix(), prevKey, seekPaths);
                        for (int index = seekPaths.size() - 1; index >= 0; --index) {
                            Pair seekDirPath = (Pair)seekPaths.get(index);
                            this.stack.push((Pair<String, String>)seekDirPath);
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)this.getKeyPrefix())) {
                        if (!OzoneFSUtils.isAncestorPath((String)this.getKeyPrefix(), (String)prevKey)) {
                            return new ArrayList<OzoneKey>();
                        }
                        if (StringUtils.compare((String)prevKey, (String)this.getKeyPrefix()) < 0) {
                            this.stack.push((Pair<String, String>)new ImmutablePair((Object)this.getKeyPrefix(), (Object)""));
                        }
                    }
                }
            }
            ArrayList<OzoneKey> keysResultList = new ArrayList<OzoneKey>();
            if (this.stack.isEmpty() && this.getChildrenKeys(this.getKeyPrefix(), prevKey, keysResultList)) {
                return keysResultList;
            }
            while (!this.stack.isEmpty() && !this.getChildrenKeys((String)(keyPrefixPath = this.stack.pop()).getLeft(), (String)keyPrefixPath.getRight(), keysResultList)) {
            }
            return keysResultList;
        }

        private void addPrevDirectoryToSeekPath(String prevKey, List<Pair<String, String>> seekPaths) throws IOException {
            try {
                OzoneFileStatus prevStatus = OzoneBucket.this.proxy.getOzoneFileStatus(OzoneBucket.this.volumeName, OzoneBucket.this.name, prevKey);
                if (prevStatus != null && prevStatus.isDirectory()) {
                    seekPaths.add((Pair<String, String>)new ImmutablePair((Object)prevKey, (Object)""));
                }
            }
            catch (OMException oMException) {
                // empty catch block
            }
        }

        private boolean getChildrenKeys(String keyPrefix, String startKey, List<OzoneKey> keysResultList) throws IOException {
            startKey = startKey == null ? "" : startKey;
            List<OzoneFileStatus> statuses = OzoneBucket.this.proxy.listStatus(OzoneBucket.this.volumeName, OzoneBucket.this.name, keyPrefix, false, startKey, OzoneBucket.this.listCacheSize, true);
            boolean reachedLimitCacheSize = statuses.size() == OzoneBucket.this.listCacheSize;
            this.addKeyPrefixInfoToResultList(keyPrefix, startKey, keysResultList);
            this.removeStartKeyIfExistsInStatusList(startKey, statuses);
            for (int indx = 0; indx < statuses.size(); ++indx) {
                OzoneFileStatus status = statuses.get(indx);
                OmKeyInfo keyInfo = status.getKeyInfo();
                String keyName = keyInfo.getKeyName();
                if (status.isDirectory()) {
                    keyName = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
                }
                OzoneKey ozoneKey = new OzoneKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyName, keyInfo.getDataSize(), keyInfo.getCreationTime(), keyInfo.getModificationTime(), keyInfo.getReplicationConfig());
                keysResultList.add(ozoneKey);
                if (status.isDirectory()) {
                    this.stack.push((Pair<String, String>)new ImmutablePair((Object)keyPrefix, (Object)keyInfo.getKeyName()));
                    this.stack.push((Pair<String, String>)new ImmutablePair((Object)keyInfo.getKeyName(), (Object)""));
                    return true;
                }
                if (!reachedLimitCacheSize || indx != statuses.size() - 1) continue;
                this.stack.push((Pair<String, String>)new ImmutablePair((Object)keyPrefix, (Object)keyInfo.getKeyName()));
                return true;
            }
            return false;
        }

        private void removeStartKeyIfExistsInStatusList(String startKey, List<OzoneFileStatus> statuses) {
            if (!statuses.isEmpty()) {
                String firstElement = statuses.get(0).getKeyInfo().getKeyName();
                String startKeyPath = startKey;
                if (StringUtils.isNotBlank((CharSequence)startKey) && startKey.endsWith("/")) {
                    startKeyPath = OzoneFSUtils.removeTrailingSlashIfNeeded((String)startKey);
                }
                if (StringUtils.equals((CharSequence)firstElement, (CharSequence)startKeyPath) || StringUtils.equals((CharSequence)firstElement, (CharSequence)this.removeStartKey)) {
                    statuses.remove(0);
                }
            }
        }

        private void addKeyPrefixInfoToResultList(String keyPrefix, String startKey, List<OzoneKey> keysResultList) throws IOException {
            OzoneFileStatus status;
            block7: {
                if (this.addedKeyPrefix) {
                    return;
                }
                this.addedKeyPrefix = true;
                if (StringUtils.isBlank((CharSequence)keyPrefix) || StringUtils.isNotBlank((CharSequence)startKey)) {
                    return;
                }
                status = null;
                try {
                    status = OzoneBucket.this.proxy.getOzoneFileStatus(OzoneBucket.this.volumeName, OzoneBucket.this.name, keyPrefix);
                }
                catch (OMException ome) {
                    if (ome.getResult() != OMException.ResultCodes.FILE_NOT_FOUND) break block7;
                    return;
                }
            }
            if (status != null) {
                OmKeyInfo keyInfo = status.getKeyInfo();
                String keyName = keyInfo.getKeyName();
                if (status.isDirectory()) {
                    keyName = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyInfo.getKeyName());
                }
                if (StringUtils.equals((CharSequence)keyName, (CharSequence)this.removeStartKey)) {
                    return;
                }
                OzoneKey ozoneKey = new OzoneKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyName, keyInfo.getDataSize(), keyInfo.getCreationTime(), keyInfo.getModificationTime(), keyInfo.getReplicationConfig());
                keysResultList.add(ozoneKey);
            }
        }
    }

    private class KeyIterator
    implements Iterator<OzoneKey> {
        private String keyPrefix = null;
        private Iterator<OzoneKey> currentIterator;
        private OzoneKey currentValue;

        String getKeyPrefix() {
            return this.keyPrefix;
        }

        void setKeyPrefix(String keyPrefixPath) {
            this.keyPrefix = keyPrefixPath;
        }

        KeyIterator(String keyPrefix, String prevKey) throws IOException {
            this.setKeyPrefix(keyPrefix);
            this.currentValue = null;
            this.currentIterator = this.getNextListOfKeys(prevKey).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext() && this.currentValue != null) {
                try {
                    this.currentIterator = this.getNextListOfKeys(this.currentValue.getName()).iterator();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneKey next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        List<OzoneKey> getNextListOfKeys(String prevKey) throws IOException {
            return OzoneBucket.this.proxy.listKeys(OzoneBucket.this.volumeName, OzoneBucket.this.name, this.keyPrefix, prevKey, OzoneBucket.this.listCacheSize);
        }
    }
}

