/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.client.rpc.RpcClient;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClientFactory.class);

    private OzoneClientFactory() {
    }

    public static OzoneClient getRpcClient() throws IOException {
        LOG.info("Creating OzoneClient with default configuration.");
        return OzoneClientFactory.getRpcClient((ConfigurationSource)new OzoneConfiguration());
    }

    public static OzoneClient getRpcClient(String omHost, Integer omRpcPort, MutableConfigurationSource config) throws IOException {
        Preconditions.checkNotNull((Object)omHost);
        Preconditions.checkNotNull((Object)omRpcPort);
        Preconditions.checkNotNull((Object)config);
        config.set("ozone.om.address", omHost + ":" + omRpcPort);
        return OzoneClientFactory.getRpcClient(OzoneClientFactory.getClientProtocol((ConfigurationSource)config), (ConfigurationSource)config);
    }

    public static OzoneClient getRpcClient(String omServiceId, ConfigurationSource config) throws IOException {
        Preconditions.checkNotNull((Object)omServiceId);
        Preconditions.checkNotNull((Object)config);
        if (OmUtils.isOmHAServiceId((ConfigurationSource)config, (String)omServiceId)) {
            return OzoneClientFactory.getRpcClient(OzoneClientFactory.getClientProtocol(config, omServiceId), config);
        }
        throw new IOException("Service ID specified does not match with ozone.om.service.ids defined in the configuration. Configured ozone.om.service.ids are" + config.getTrimmedStringCollection("ozone.om.service.ids"));
    }

    public static OzoneClient getRpcClient(ConfigurationSource config) throws IOException {
        Preconditions.checkNotNull((Object)config);
        String[] serviceIds = config.getTrimmedStrings("ozone.om.service.ids");
        if (serviceIds.length > 1) {
            throw new IOException("Following ServiceID's " + config.getTrimmedStringCollection("ozone.om.service.ids") + " are defined in the configuration. Use the method getRpcClient which takes serviceID and configuration as param");
        }
        if (serviceIds.length == 1) {
            return OzoneClientFactory.getRpcClient(OzoneClientFactory.getClientProtocol(config, serviceIds[0]), config);
        }
        return OzoneClientFactory.getRpcClient(OzoneClientFactory.getClientProtocol(config), config);
    }

    private static OzoneClient getRpcClient(ClientProtocol clientProtocol, ConfigurationSource config) {
        return new OzoneClient(config, clientProtocol);
    }

    public static OzoneClient getOzoneClient(Configuration conf, Token<OzoneTokenIdentifier> token) throws IOException {
        Preconditions.checkNotNull(token, (Object)"Null token is not allowed");
        OzoneTokenIdentifier tokenId = new OzoneTokenIdentifier();
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        tokenId.readFields((DataInput)in);
        String omServiceId = tokenId.getOmServiceId();
        OzoneConfiguration ozoneConf = OzoneConfiguration.of((Configuration)conf);
        if (StringUtils.isNotEmpty((CharSequence)omServiceId)) {
            if (!OmUtils.isServiceIdsDefined((ConfigurationSource)ozoneConf) && omServiceId.equals("omServiceIdDefault")) {
                return OzoneClientFactory.getRpcClient((ConfigurationSource)ozoneConf);
            }
            if (OmUtils.isOmHAServiceId((ConfigurationSource)ozoneConf, (String)omServiceId)) {
                return OzoneClientFactory.getRpcClient(omServiceId, (ConfigurationSource)ozoneConf);
            }
            throw new IOException("Service ID specified " + omServiceId + " does not match with " + "ozone.om.service.ids" + " defined in the configuration. Configured " + "ozone.om.service.ids" + " are" + ozoneConf.getTrimmedStringCollection("ozone.om.service.ids"));
        }
        if (!OmUtils.isServiceIdsDefined((ConfigurationSource)ozoneConf)) {
            return OzoneClientFactory.getRpcClient((ConfigurationSource)ozoneConf);
        }
        throw new IOException("OzoneToken with no service ID can't be renewed or canceled with local OM HA setup because we don't know if the token is issued from local OM HA cluster or not.");
    }

    private static ClientProtocol getClientProtocol(ConfigurationSource config) throws IOException {
        return OzoneClientFactory.getClientProtocol(config, null);
    }

    private static ClientProtocol getClientProtocol(ConfigurationSource config, String omServiceId) throws IOException {
        try {
            return new RpcClient(config, omServiceId);
        }
        catch (Exception e) {
            String message = "Couldn't create RpcClient protocol";
            LOG.error("Couldn't create RpcClient protocol exception: ", (Throwable)e);
            if (e instanceof RemoteException) {
                throw ((RemoteException)e).unwrapRemoteException();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException("Couldn't create RpcClient protocol", e);
        }
    }
}

