/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.ContainerClientMetrics;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockOutputStream;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.scm.storage.RatisBlockOutputStream;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.security.token.Token;

public class BlockOutputStreamEntry
extends OutputStream {
    private final OzoneClientConfig config;
    private OutputStream outputStream;
    private BlockID blockID;
    private final String key;
    private final XceiverClientFactory xceiverClientManager;
    private final Pipeline pipeline;
    private final long length;
    private long currentPosition;
    private final Token<OzoneBlockTokenIdentifier> token;
    private BufferPool bufferPool;
    private ContainerClientMetrics clientMetrics;

    BlockOutputStreamEntry(BlockID blockID, String key, XceiverClientFactory xceiverClientManager, Pipeline pipeline, long length, BufferPool bufferPool, Token<OzoneBlockTokenIdentifier> token, OzoneClientConfig config, ContainerClientMetrics clientMetrics) {
        this.config = config;
        this.outputStream = null;
        this.blockID = blockID;
        this.key = key;
        this.xceiverClientManager = xceiverClientManager;
        this.pipeline = pipeline;
        this.token = token;
        this.length = length;
        this.currentPosition = 0L;
        this.bufferPool = bufferPool;
        this.clientMetrics = clientMetrics;
    }

    void checkStream() throws IOException {
        if (!this.isInitialized()) {
            this.createOutputStream();
        }
    }

    void createOutputStream() throws IOException {
        this.outputStream = new RatisBlockOutputStream(this.blockID, this.xceiverClientManager, this.pipeline, this.bufferPool, this.config, this.token, this.clientMetrics);
    }

    ContainerClientMetrics getClientMetrics() {
        return this.clientMetrics;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkStream();
        this.getOutputStream().write(b);
        this.incCurrentPosition();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        this.getOutputStream().write(b, off, len);
        this.incCurrentPosition(len);
    }

    void writeOnRetry(long len) throws IOException {
        this.checkStream();
        BlockOutputStream out = (BlockOutputStream)this.getOutputStream();
        out.writeOnRetry(len);
        this.incCurrentPosition(len);
    }

    @Override
    public void flush() throws IOException {
        if (this.isInitialized()) {
            this.getOutputStream().flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isInitialized()) {
            this.getOutputStream().close();
            this.blockID = ((BlockOutputStream)this.getOutputStream()).getBlockID();
        }
    }

    boolean isClosed() {
        if (this.isInitialized()) {
            return ((BlockOutputStream)this.getOutputStream()).isClosed();
        }
        return false;
    }

    void cleanup(boolean invalidateClient) throws IOException {
        this.checkStream();
        BlockOutputStream out = (BlockOutputStream)this.getOutputStream();
        out.cleanup(invalidateClient);
    }

    long getTotalAckDataLength() {
        if (this.isInitialized()) {
            BlockOutputStream out = (BlockOutputStream)this.getOutputStream();
            this.blockID = out.getBlockID();
            return out.getTotalAckDataLength();
        }
        return 0L;
    }

    long getWrittenDataLength() {
        if (this.isInitialized()) {
            BlockOutputStream out = (BlockOutputStream)this.getOutputStream();
            return out.getWrittenDataLength();
        }
        return 0L;
    }

    Collection<DatanodeDetails> getFailedServers() {
        if (this.isInitialized()) {
            BlockOutputStream out = (BlockOutputStream)this.getOutputStream();
            return out.getFailedServers();
        }
        return Collections.emptyList();
    }

    boolean isInitialized() {
        return this.getOutputStream() != null;
    }

    long getLength() {
        return this.length;
    }

    Token<OzoneBlockTokenIdentifier> getToken() {
        return this.token;
    }

    long getRemaining() {
        return this.getLength() - this.getCurrentPosition();
    }

    void incCurrentPosition(long len) {
        this.currentPosition += len;
    }

    void incCurrentPosition() {
        ++this.currentPosition;
    }

    void resetToAckedPosition() {
        this.currentPosition = this.getTotalAckDataLength();
    }

    @VisibleForTesting
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @VisibleForTesting
    public BlockID getBlockID() {
        return this.blockID;
    }

    @VisibleForTesting
    protected void updateBlockID(BlockID id) {
        this.blockID = id;
    }

    OzoneClientConfig getConf() {
        return this.config;
    }

    XceiverClientFactory getXceiverClientManager() {
        return this.xceiverClientManager;
    }

    @VisibleForTesting
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    Pipeline getPipelineForOMLocationReport() {
        return this.getPipeline();
    }

    long getCurrentPosition() {
        return this.currentPosition;
    }

    BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public static class Builder {
        private BlockID blockID;
        private String key;
        private XceiverClientFactory xceiverClientManager;
        private Pipeline pipeline;
        private long length;
        private BufferPool bufferPool;
        private Token<OzoneBlockTokenIdentifier> token;
        private OzoneClientConfig config;
        private ContainerClientMetrics clientMetrics;

        public Builder setBlockID(BlockID bID) {
            this.blockID = bID;
            return this;
        }

        public Builder setKey(String keys) {
            this.key = keys;
            return this;
        }

        public Builder setXceiverClientManager(XceiverClientFactory xClientManager) {
            this.xceiverClientManager = xClientManager;
            return this;
        }

        public Builder setPipeline(Pipeline ppln) {
            this.pipeline = ppln;
            return this;
        }

        public Builder setLength(long len) {
            this.length = len;
            return this;
        }

        public Builder setBufferPool(BufferPool pool) {
            this.bufferPool = pool;
            return this;
        }

        public Builder setConfig(OzoneClientConfig clientConfig) {
            this.config = clientConfig;
            return this;
        }

        public Builder setToken(Token<OzoneBlockTokenIdentifier> bToken) {
            this.token = bToken;
            return this;
        }

        public Builder setClientMetrics(ContainerClientMetrics clientMetrics) {
            this.clientMetrics = clientMetrics;
            return this;
        }

        public BlockOutputStreamEntry build() {
            return new BlockOutputStreamEntry(this.blockID, this.key, this.xceiverClientManager, this.pipeline, this.length, this.bufferPool, this.token, this.config, this.clientMetrics);
        }
    }
}

