/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.time.Clock;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.scm.ContainerClientMetrics;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.ozone.client.io.BlockOutputStreamEntry;
import org.apache.hadoop.ozone.client.io.BlockOutputStreamEntryPool;
import org.apache.hadoop.ozone.client.io.ECBlockOutputStreamEntry;
import org.apache.hadoop.ozone.common.MonotonicClock;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.security.token.Token;

public class ECBlockOutputStreamEntryPool
extends BlockOutputStreamEntryPool {
    public ECBlockOutputStreamEntryPool(OzoneClientConfig config, OzoneManagerProtocol omClient, String requestId, ReplicationConfig replicationConfig, String uploadID, int partNumber, boolean isMultipart, OmKeyInfo info, boolean unsafeByteBufferConversion, XceiverClientFactory xceiverClientFactory, long openID, ContainerClientMetrics clientMetrics) {
        super(config, omClient, requestId, replicationConfig, uploadID, partNumber, isMultipart, info, unsafeByteBufferConversion, xceiverClientFactory, openID, clientMetrics);
        assert (replicationConfig instanceof ECReplicationConfig);
    }

    @Override
    ExcludeList createExcludeList() {
        return new ExcludeList(this.getConfig().getExcludeNodesExpiryTime(), (Clock)new MonotonicClock((ZoneId)ZoneOffset.UTC));
    }

    @Override
    BlockOutputStreamEntry createStreamEntry(OmKeyLocationInfo subKeyInfo) {
        return new ECBlockOutputStreamEntry.Builder().setBlockID(subKeyInfo.getBlockID()).setKey(this.getKeyName()).setXceiverClientManager(this.getXceiverClientFactory()).setPipeline(subKeyInfo.getPipeline()).setConfig(this.getConfig()).setLength(subKeyInfo.getLength()).setBufferPool(this.getBufferPool()).setToken((Token<OzoneBlockTokenIdentifier>)subKeyInfo.getToken()).setClientMetrics(this.getClientMetrics()).build();
    }

    @Override
    public ECBlockOutputStreamEntry getCurrentStreamEntry() {
        return (ECBlockOutputStreamEntry)super.getCurrentStreamEntry();
    }
}

