/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ha;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.ha.OMProxyInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMFailoverProxyProvider<T>
implements FailoverProxyProvider<T>,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(OMFailoverProxyProvider.class);
    private final String omServiceId;
    private final ConfigurationSource conf;
    private final Class<T> protocolClass;
    private final long omVersion;
    private final UserGroupInformation ugi;
    private final Text delegationTokenService;
    private Map<String, FailoverProxyProvider.ProxyInfo<T>> omProxies;
    private Map<String, OMProxyInfo> omProxyInfos;
    private List<String> omNodeIDList;
    private String currentProxyOMNodeId;
    private int currentProxyIndex;
    private List<String> retryExceptions = new ArrayList<String>();
    private Set<String> attemptedOMs = new HashSet<String>();
    private String lastAttemptedOM;
    private int numAttemptsOnSameOM = 0;
    private final long waitBetweenRetries;
    private Set<String> accessControlExceptionOMs = new HashSet<String>();

    public OMFailoverProxyProvider(ConfigurationSource configuration, UserGroupInformation ugi, String omServiceId, Class<T> protocol) throws IOException {
        this.conf = configuration;
        this.omVersion = RPC.getProtocolVersion(protocol);
        this.ugi = ugi;
        this.omServiceId = omServiceId;
        this.protocolClass = protocol;
        this.loadOMClientConfigs(this.conf, this.omServiceId);
        this.delegationTokenService = this.computeDelegationTokenService();
        this.currentProxyIndex = 0;
        this.currentProxyOMNodeId = this.omNodeIDList.get(this.currentProxyIndex);
        this.waitBetweenRetries = this.conf.getLong("ozone.client.wait.between.retries.millis", 2000L);
    }

    protected void loadOMClientConfigs(ConfigurationSource config, String omSvcId) throws IOException {
        this.omProxies = new HashMap<String, FailoverProxyProvider.ProxyInfo<T>>();
        this.omProxyInfos = new HashMap<String, OMProxyInfo>();
        this.omNodeIDList = new ArrayList<String>();
        List<String> omServiceIds = Collections.singletonList(omSvcId);
        for (String serviceId : OmUtils.emptyAsSingletonNull(omServiceIds)) {
            Collection<String> omNodeIds = OmUtils.getOMNodeIds(config, serviceId);
            for (String nodeId : OmUtils.emptyAsSingletonNull(omNodeIds)) {
                String rpcAddrKey = ConfUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{serviceId, nodeId});
                String rpcAddrStr = OmUtils.getOmRpcAddress(config, rpcAddrKey);
                if (rpcAddrStr == null) continue;
                OMProxyInfo omProxyInfo = new OMProxyInfo(serviceId, nodeId, rpcAddrStr);
                if (omProxyInfo.getAddress() != null) {
                    if (nodeId == null) {
                        nodeId = "om1";
                    }
                    this.omProxies.put(nodeId, null);
                    this.omProxyInfos.put(nodeId, omProxyInfo);
                    this.omNodeIDList.add(nodeId);
                    continue;
                }
                LOG.error("Failed to create OM proxy for {} at address {}", (Object)nodeId, (Object)rpcAddrStr);
            }
        }
        if (this.omProxies.isEmpty()) {
            throw new IllegalArgumentException("Could not find any configured addresses for OM. Please configure the system with ozone.om.address");
        }
    }

    @VisibleForTesting
    public synchronized String getCurrentProxyOMNodeId() {
        return this.currentProxyOMNodeId;
    }

    private T createOMProxy(InetSocketAddress omAddress) throws IOException {
        Configuration hadoopConf = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)this.conf);
        RPC.setProtocolEngine((Configuration)hadoopConf, this.protocolClass, ProtobufRpcEngine.class);
        RetryPolicy connectionRetryPolicy = RetryPolicies.failoverOnNetworkException((int)0);
        return (T)RPC.getProtocolProxy(this.protocolClass, (long)this.omVersion, (InetSocketAddress)omAddress, (UserGroupInformation)this.ugi, (Configuration)hadoopConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConf), (int)((int)OmUtils.getOMClientRpcTimeOut(this.conf)), (RetryPolicy)connectionRetryPolicy).getProxy();
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        FailoverProxyProvider.ProxyInfo currentProxyInfo = this.omProxies.get(this.currentProxyOMNodeId);
        if (currentProxyInfo == null) {
            currentProxyInfo = this.createOMProxy(this.currentProxyOMNodeId);
        }
        return currentProxyInfo;
    }

    protected FailoverProxyProvider.ProxyInfo createOMProxy(String nodeId) {
        FailoverProxyProvider.ProxyInfo proxyInfo;
        OMProxyInfo omProxyInfo = this.omProxyInfos.get(nodeId);
        InetSocketAddress address = omProxyInfo.getAddress();
        try {
            T proxy = this.createOMProxy(address);
            proxyInfo = new FailoverProxyProvider.ProxyInfo(proxy, omProxyInfo.toString());
            this.omProxies.put(nodeId, proxyInfo);
        }
        catch (IOException ioe) {
            LOG.error("{} Failed to create RPC proxy to OM at {}", new Object[]{this.getClass().getSimpleName(), address, ioe});
            throw new RuntimeException(ioe);
        }
        return proxyInfo;
    }

    @VisibleForTesting
    public RetryPolicy getRetryPolicy(final int maxFailovers) {
        RetryPolicy retryPolicy = new RetryPolicy(){

            public RetryPolicy.RetryAction shouldRetry(Exception exception, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
                String omNodeId = OMFailoverProxyProvider.this.getCurrentProxyOMNodeId();
                if (LOG.isDebugEnabled()) {
                    if (exception.getCause() != null) {
                        LOG.debug("RetryProxy: OM {}: {}: {}", new Object[]{omNodeId, exception.getCause().getClass().getSimpleName(), exception.getCause().getMessage()});
                    } else {
                        LOG.debug("RetryProxy: OM {}: {}", (Object)omNodeId, (Object)exception.getMessage());
                    }
                }
                if (exception instanceof ServiceException) {
                    OMNotLeaderException notLeaderException = OMFailoverProxyProvider.getNotLeaderException(exception);
                    if (notLeaderException != null) {
                        OMFailoverProxyProvider.this.performFailoverToNextProxy();
                        return this.getRetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, failovers);
                    }
                    OMLeaderNotReadyException leaderNotReadyException = OMFailoverProxyProvider.getLeaderNotReadyException(exception);
                    if (leaderNotReadyException != null) {
                        OMFailoverProxyProvider.this.performFailoverIfRequired(omNodeId);
                        return this.getRetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, failovers);
                    }
                }
                if (!OMFailoverProxyProvider.this.shouldFailover(exception)) {
                    return RetryPolicy.RetryAction.FAIL;
                }
                OMFailoverProxyProvider.this.performFailoverToNextProxy();
                return this.getRetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, failovers);
            }

            private RetryPolicy.RetryAction getRetryAction(RetryPolicy.RetryAction.RetryDecision fallbackAction, int failovers) {
                if (failovers < maxFailovers) {
                    return new RetryPolicy.RetryAction(fallbackAction, OMFailoverProxyProvider.this.getWaitTime());
                }
                LOG.error("Failed to connect to OMs: {}. Attempted {} failovers.", OMFailoverProxyProvider.this.getOMProxyInfos(), (Object)maxFailovers);
                return RetryPolicy.RetryAction.FAIL;
            }
        };
        return retryPolicy;
    }

    public Text getCurrentProxyDelegationToken() {
        return this.delegationTokenService;
    }

    protected Text computeDelegationTokenService() {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Map.Entry<String, OMProxyInfo> omProxyInfoSet : this.omProxyInfos.entrySet()) {
            Text dtService = omProxyInfoSet.getValue().getDelegationTokenService();
            if (dtService == null) continue;
            addresses.add(dtService.toString());
        }
        if (!addresses.isEmpty()) {
            Collections.sort(addresses);
            return new Text(String.join((CharSequence)",", addresses));
        }
        return null;
    }

    public Class<T> getInterface() {
        return this.protocolClass;
    }

    public void performFailover(T currentProxy) {
        if (LOG.isDebugEnabled()) {
            int currentIndex = this.getCurrentProxyIndex();
            LOG.debug("Failing over OM proxy to index: {}, nodeId: {}", (Object)currentIndex, (Object)this.omNodeIDList.get(currentIndex));
        }
    }

    public void performFailoverIfRequired(String newLeaderOMNodeId) {
        if (newLeaderOMNodeId == null) {
            LOG.debug("No suggested leader nodeId. Performing failover to next peer node");
            this.performFailoverToNextProxy();
        } else if (this.updateLeaderOMNodeId(newLeaderOMNodeId)) {
            LOG.debug("Failing over OM proxy to nodeId: {}", (Object)newLeaderOMNodeId);
        }
    }

    public void performFailoverToNextProxy() {
        int newProxyIndex = this.incrementProxyIndex();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Incrementing OM proxy index to {}, nodeId: {}", (Object)newProxyIndex, (Object)this.omNodeIDList.get(newProxyIndex));
        }
    }

    private synchronized int incrementProxyIndex() {
        this.lastAttemptedOM = this.currentProxyOMNodeId;
        this.attemptedOMs.add(this.currentProxyOMNodeId);
        this.currentProxyIndex = (this.currentProxyIndex + 1) % this.omProxies.size();
        this.currentProxyOMNodeId = this.omNodeIDList.get(this.currentProxyIndex);
        return this.currentProxyIndex;
    }

    synchronized boolean updateLeaderOMNodeId(String newLeaderOMNodeId) {
        if (!this.currentProxyOMNodeId.equals(newLeaderOMNodeId)) {
            if (this.omProxies.containsKey(newLeaderOMNodeId)) {
                this.lastAttemptedOM = this.currentProxyOMNodeId;
                this.currentProxyOMNodeId = newLeaderOMNodeId;
                this.currentProxyIndex = this.omNodeIDList.indexOf(this.currentProxyOMNodeId);
                return true;
            }
        } else {
            this.lastAttemptedOM = this.currentProxyOMNodeId;
        }
        return false;
    }

    private synchronized int getCurrentProxyIndex() {
        return this.currentProxyIndex;
    }

    public synchronized long getWaitTime() {
        if (this.currentProxyOMNodeId.equals(this.lastAttemptedOM)) {
            this.attemptedOMs.clear();
            ++this.numAttemptsOnSameOM;
            return this.waitBetweenRetries * (long)this.numAttemptsOnSameOM;
        }
        this.numAttemptsOnSameOM = 0;
        for (String omNodeID : this.omProxyInfos.keySet()) {
            if (this.attemptedOMs.contains(omNodeID)) continue;
            return 0L;
        }
        this.attemptedOMs.clear();
        return this.waitBetweenRetries;
    }

    public synchronized boolean shouldFailover(Exception ex) {
        StateMachineException smEx;
        Throwable cause;
        if (OmUtils.isAccessControlException(ex)) {
            if (this.accessControlExceptionOMs.contains(this.currentProxyOMNodeId)) {
                this.accessControlExceptionOMs.clear();
                return false;
            }
            this.accessControlExceptionOMs.add(this.currentProxyOMNodeId);
            if (this.accessControlExceptionOMs.containsAll(this.omNodeIDList)) {
                return false;
            }
        } else if (ex instanceof StateMachineException && (cause = (smEx = (StateMachineException)ex).getCause()) instanceof OMException) {
            OMException omEx = (OMException)cause;
            return omEx.getResult() != OMException.ResultCodes.NOT_SUPPORTED_OPERATION_WHEN_PREPARED;
        }
        return true;
    }

    @Override
    public synchronized void close() throws IOException {
        for (FailoverProxyProvider.ProxyInfo<T> proxyInfo : this.omProxies.values()) {
            if (proxyInfo == null) continue;
            RPC.stopProxy((Object)proxyInfo.proxy);
        }
    }

    @VisibleForTesting
    public List<FailoverProxyProvider.ProxyInfo> getOMProxies() {
        return new ArrayList<FailoverProxyProvider.ProxyInfo>(this.omProxies.values());
    }

    @VisibleForTesting
    public Map<String, FailoverProxyProvider.ProxyInfo<T>> getOMProxyMap() {
        return this.omProxies;
    }

    @VisibleForTesting
    public List<OMProxyInfo> getOMProxyInfos() {
        return new ArrayList<OMProxyInfo>(this.omProxyInfos.values());
    }

    public static OMLeaderNotReadyException getLeaderNotReadyException(Exception exception) {
        IOException ioException;
        Throwable cause = exception.getCause();
        if (cause instanceof RemoteException && (ioException = ((RemoteException)cause).unwrapRemoteException()) instanceof OMLeaderNotReadyException) {
            return (OMLeaderNotReadyException)ioException;
        }
        return null;
    }

    public static OMNotLeaderException getNotLeaderException(Exception exception) {
        IOException ioException;
        Throwable cause = exception.getCause();
        if (cause instanceof RemoteException && (ioException = ((RemoteException)cause).unwrapRemoteException()) instanceof OMNotLeaderException) {
            return (OMNotLeaderException)ioException;
        }
        return null;
    }

    @VisibleForTesting
    protected void setProxiesForTesting(Map<String, FailoverProxyProvider.ProxyInfo<T>> testOMProxies, Map<String, OMProxyInfo> testOMProxyInfos, List<String> testOMNodeIDList) {
        this.omProxies = testOMProxies;
        this.omProxyInfos = testOMProxyInfos;
        this.omNodeIDList = testOMNodeIDList;
    }
}

