/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.net.InetSocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.NodeDetails;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.ha.ConfUtils;

public final class OMNodeDetails
extends NodeDetails {
    private int rpcPort;

    private OMNodeDetails(String serviceId, String nodeId, InetSocketAddress rpcAddr, int rpcPort, int ratisPort, String httpAddress, String httpsAddress) {
        super(serviceId, nodeId, rpcAddr, ratisPort, httpAddress, httpsAddress);
        this.rpcPort = rpcPort;
    }

    private OMNodeDetails(String serviceId, String nodeId, String hostAddr, int rpcPort, int ratisPort, String httpAddress, String httpsAddress) {
        super(serviceId, nodeId, hostAddr, rpcPort, ratisPort, httpAddress, httpsAddress);
        this.rpcPort = rpcPort;
    }

    public String toString() {
        return "OMNodeDetails[omServiceId=" + this.getServiceId() + ", omNodeId=" + this.getNodeId() + ", rpcAddress=" + this.getRpcAddressString() + ", rpcPort=" + this.getRpcPort() + ", ratisPort=" + this.getRatisPort() + ", httpAddress=" + this.getHttpAddress() + ", httpsAddress=" + this.getHttpsAddress() + "]";
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public String getOMDBCheckpointEnpointUrl(boolean isHttpPolicy) {
        if (isHttpPolicy) {
            if (StringUtils.isNotEmpty((CharSequence)this.getHttpAddress())) {
                return "http://" + this.getHttpAddress() + "/dbCheckpoint" + "?" + "flushBeforeCheckpoint" + "=true";
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.getHttpsAddress())) {
            return "https://" + this.getHttpsAddress() + "/dbCheckpoint" + "?" + "flushBeforeCheckpoint" + "=true";
        }
        return null;
    }

    public static OMNodeDetails getOMNodeDetailsFromConf(OzoneConfiguration conf, String omServiceId, String omNodeId) {
        String rpcAddrKey = ConfUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{omServiceId, omNodeId});
        String rpcAddrStr = OmUtils.getOmRpcAddress((ConfigurationSource)conf, rpcAddrKey);
        if (rpcAddrStr == null || rpcAddrStr.isEmpty()) {
            return null;
        }
        String ratisPortKey = ConfUtils.addKeySuffixes((String)"ozone.om.ratis.port", (String[])new String[]{omServiceId, omNodeId});
        int ratisPort = conf.getInt(ratisPortKey, 9872);
        InetSocketAddress omRpcAddress = null;
        try {
            omRpcAddress = NetUtils.createSocketAddr((String)rpcAddrStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't create socket address for OM " + omNodeId + " at " + rpcAddrStr, e);
        }
        String httpAddr = OmUtils.getHttpAddressForOMPeerNode((ConfigurationSource)conf, omServiceId, omNodeId, omRpcAddress.getHostName());
        String httpsAddr = OmUtils.getHttpsAddressForOMPeerNode((ConfigurationSource)conf, omServiceId, omNodeId, omRpcAddress.getHostName());
        return new Builder().setOMNodeId(omNodeId).setRpcAddress(omRpcAddress).setRatisPort(ratisPort).setHttpAddress(httpAddr).setHttpsAddress(httpsAddr).setOMServiceId(omServiceId).build();
    }

    public static class Builder {
        private String omServiceId;
        private String omNodeId;
        private String hostAddress;
        private InetSocketAddress rpcAddress;
        private int rpcPort;
        private int ratisPort;
        private String httpAddr;
        private String httpsAddr;

        public Builder setHostAddress(String hostName) {
            this.hostAddress = hostName;
            return this;
        }

        public Builder setRpcAddress(InetSocketAddress rpcAddr) {
            this.rpcAddress = rpcAddr;
            this.rpcPort = this.rpcAddress.getPort();
            return this;
        }

        public Builder setRatisAddress(InetSocketAddress ratisAddr) {
            this.hostAddress = ratisAddr.getHostName();
            this.ratisPort = ratisAddr.getPort();
            return this;
        }

        public Builder setRpcPort(int port) {
            this.rpcPort = port;
            return this;
        }

        public Builder setRatisPort(int port) {
            this.ratisPort = port;
            return this;
        }

        public Builder setOMServiceId(String serviceId) {
            this.omServiceId = serviceId;
            return this;
        }

        public Builder setOMNodeId(String nodeId) {
            this.omNodeId = nodeId;
            return this;
        }

        public Builder setHttpAddress(String httpAddress) {
            this.httpAddr = httpAddress;
            return this;
        }

        public Builder setHttpsAddress(String httpsAddress) {
            this.httpsAddr = httpsAddress;
            return this;
        }

        public OMNodeDetails build() {
            if (this.rpcAddress != null) {
                return new OMNodeDetails(this.omServiceId, this.omNodeId, this.rpcAddress, this.rpcPort, this.ratisPort, this.httpAddr, this.httpsAddr);
            }
            return new OMNodeDetails(this.omServiceId, this.omNodeId, this.hostAddress, this.rpcPort, this.ratisPort, this.httpAddr, this.httpsAddr);
        }
    }
}

