/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OmMultipartKeyInfo
extends WithObjectID {
    private final String uploadID;
    private final long creationTime;
    private final ReplicationConfig replicationConfig;
    private TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> partKeyInfoList;
    private long parentID;

    public OmMultipartKeyInfo(String id, long creationTime, ReplicationConfig replicationConfig, Map<Integer, OzoneManagerProtocolProtos.PartKeyInfo> list, long objectID, long updateID) {
        this.uploadID = id;
        this.creationTime = creationTime;
        this.replicationConfig = replicationConfig;
        this.partKeyInfoList = new TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo>(list);
        this.objectID = objectID;
        this.updateID = updateID;
    }

    public OmMultipartKeyInfo(String id, long creationTime, ReplicationConfig replicationConfig, Map<Integer, OzoneManagerProtocolProtos.PartKeyInfo> list, long objectID, long updateID, long parentObjId) {
        this(id, creationTime, replicationConfig, list, objectID, updateID);
        this.parentID = parentObjId;
    }

    public long getParentID() {
        return this.parentID;
    }

    public String getUploadID() {
        return this.uploadID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> getPartKeyInfoMap() {
        return this.partKeyInfoList;
    }

    public void addPartKeyInfo(int partNumber, OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo) {
        this.partKeyInfoList.put(partNumber, partKeyInfo);
    }

    public OzoneManagerProtocolProtos.PartKeyInfo getPartKeyInfo(int partNumber) {
        return this.partKeyInfoList.get(partNumber);
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public static OmMultipartKeyInfo getFromProto(OzoneManagerProtocolProtos.MultipartKeyInfo multipartKeyInfo) {
        HashMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> list = new HashMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo>();
        multipartKeyInfo.getPartKeyInfoListList().forEach(partKeyInfo -> list.put(partKeyInfo.getPartNumber(), (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfo));
        ReplicationConfig replicationConfig = ReplicationConfig.fromProto((HddsProtos.ReplicationType)multipartKeyInfo.getType(), (HddsProtos.ReplicationFactor)multipartKeyInfo.getFactor(), (HddsProtos.ECReplicationConfig)multipartKeyInfo.getEcReplicationConfig());
        return new OmMultipartKeyInfo(multipartKeyInfo.getUploadID(), multipartKeyInfo.getCreationTime(), replicationConfig, list, multipartKeyInfo.getObjectID(), multipartKeyInfo.getUpdateID(), multipartKeyInfo.getParentID());
    }

    public OzoneManagerProtocolProtos.MultipartKeyInfo getProto() {
        OzoneManagerProtocolProtos.MultipartKeyInfo.Builder builder = OzoneManagerProtocolProtos.MultipartKeyInfo.newBuilder().setUploadID(this.uploadID).setCreationTime(this.creationTime).setType(this.replicationConfig.getReplicationType()).setObjectID(this.objectID).setUpdateID(this.updateID).setParentID(this.parentID);
        if (this.replicationConfig instanceof ECReplicationConfig) {
            ECReplicationConfig ecConf = (ECReplicationConfig)this.replicationConfig;
            builder.setEcReplicationConfig(ecConf.toProto());
        } else {
            builder.setFactor(ReplicationConfig.getLegacyFactor((ReplicationConfig)this.replicationConfig));
        }
        this.partKeyInfoList.forEach((key, value) -> builder.addPartKeyInfoList(value));
        return builder.build();
    }

    @Override
    public String getObjectInfo() {
        return this.getProto().toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OmMultipartKeyInfo && this.uploadID.equals(((OmMultipartKeyInfo)other).getUploadID());
    }

    public int hashCode() {
        return this.uploadID.hashCode();
    }

    public OmMultipartKeyInfo copyObject() {
        return new OmMultipartKeyInfo(this.uploadID, this.creationTime, this.replicationConfig, new TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo>((SortedMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo>)this.partKeyInfoList), this.objectID, this.updateID, this.parentID);
    }

    public static class Builder {
        private String uploadID;
        private long creationTime;
        private ReplicationConfig replicationConfig;
        private TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> partKeyInfoList = new TreeMap();
        private long objectID;
        private long updateID;
        private long parentID;

        public Builder setUploadID(String uploadId) {
            this.uploadID = uploadId;
            return this;
        }

        public Builder setCreationTime(long crTime) {
            this.creationTime = crTime;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig replConfig) {
            this.replicationConfig = replConfig;
            return this;
        }

        public Builder setPartKeyInfoList(Map<Integer, OzoneManagerProtocolProtos.PartKeyInfo> partKeyInfos) {
            if (partKeyInfos != null) {
                this.partKeyInfoList.putAll(partKeyInfos);
            }
            return this;
        }

        public Builder addPartKeyInfoList(int partNum, OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo) {
            if (partKeyInfo != null) {
                this.partKeyInfoList.put(partNum, partKeyInfo);
            }
            return this;
        }

        public Builder setObjectID(long obId) {
            this.objectID = obId;
            return this;
        }

        public Builder setUpdateID(long id) {
            this.updateID = id;
            return this;
        }

        public Builder setParentID(long parentObjId) {
            this.parentID = parentObjId;
            return this;
        }

        public OmMultipartKeyInfo build() {
            return new OmMultipartKeyInfo(this.uploadID, this.creationTime, this.replicationConfig, this.partKeyInfoList, this.objectID, this.updateID, this.parentID);
        }
    }
}

