/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.time.Instant;
import org.apache.hadoop.hdds.client.ReplicationConfig;

public class OmMultipartUpload {
    private String volumeName;
    private String bucketName;
    private String keyName;
    private String uploadId;
    private Instant creationTime;
    private ReplicationConfig replicationConfig;

    public OmMultipartUpload(String volumeName, String bucketName, String keyName, String uploadId) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.uploadId = uploadId;
    }

    public OmMultipartUpload(String volumeName, String bucketName, String keyName, String uploadId, Instant creationDate) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.uploadId = uploadId;
        this.creationTime = creationDate;
    }

    public OmMultipartUpload(String volumeName, String bucketName, String keyName, String uploadId, Instant creationTime, ReplicationConfig replicationConfig) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.uploadId = uploadId;
        this.creationTime = creationTime;
        this.replicationConfig = replicationConfig;
    }

    public static OmMultipartUpload from(String key) {
        String[] split = key.split("/");
        if (split.length < 5) {
            throw new IllegalArgumentException("Key " + key + " doesn't have enough segments to be a valid multipart upload key");
        }
        String uploadId = split[split.length - 1];
        String volume = split[1];
        String bucket = split[2];
        return new OmMultipartUpload(volume, bucket, key.substring(volume.length() + bucket.length() + 3, key.length() - uploadId.length() - 1), uploadId);
    }

    public String getDbKey() {
        return OmMultipartUpload.getDbKey(this.volumeName, this.bucketName, this.keyName, this.uploadId);
    }

    public static String getDbKey(String volume, String bucket, String key, String uploadId) {
        return OmMultipartUpload.getDbKey(volume, bucket, key) + "/" + uploadId;
    }

    public static String getDbKey(String volume, String bucket, String key) {
        return "/" + volume + "/" + bucket + "/" + key;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    public void setReplicationConfig(ReplicationConfig replicationConfig) {
        this.replicationConfig = replicationConfig;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }
}

