/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.base.Preconditions;

public class OmTenantArgs {
    private final String tenantId;
    private final String volumeName;

    public OmTenantArgs(String tenantId) {
        this.volumeName = this.tenantId = tenantId;
    }

    public OmTenantArgs(String tenantId, String volumeName) {
        this.tenantId = tenantId;
        this.volumeName = volumeName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String tenantId;
        private String volumeName;

        public Builder setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder setVolumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public OmTenantArgs build() {
            Preconditions.checkNotNull((Object)this.tenantId);
            Preconditions.checkNotNull((Object)this.volumeName);
            return new OmTenantArgs(this.tenantId, this.volumeName);
        }
    }
}

