/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public final class QuotaUtil {
    private QuotaUtil() {
    }

    public static long getReplicatedSize(long dataSize, ReplicationConfig repConfig) {
        if (repConfig.getReplicationType() == HddsProtos.ReplicationType.RATIS) {
            return dataSize * (long)((RatisReplicationConfig)repConfig).getReplicationFactor().getNumber();
        }
        if (repConfig.getReplicationType() == HddsProtos.ReplicationType.EC) {
            ECReplicationConfig rc = (ECReplicationConfig)repConfig;
            int dataStripeSize = rc.getData() * rc.getEcChunkSize();
            long fullStripes = dataSize / (long)dataStripeSize;
            long partialFirstChunk = Math.min((long)rc.getEcChunkSize(), dataSize % (long)dataStripeSize);
            long replicationOverhead = fullStripes * (long)rc.getParity() * (long)rc.getEcChunkSize() + partialFirstChunk * (long)rc.getParity();
            return dataSize + replicationOverhead;
        }
        return dataSize;
    }
}

