/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.Objects;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class S3SecretValue {
    private String kerberosID;
    private String awsSecret;

    public S3SecretValue(String kerberosID, String awsSecret) {
        this.kerberosID = kerberosID;
        this.awsSecret = awsSecret;
    }

    public String getKerberosID() {
        return this.kerberosID;
    }

    public void setKerberosID(String kerberosID) {
        this.kerberosID = kerberosID;
    }

    public String getAwsSecret() {
        return this.awsSecret;
    }

    public void setAwsSecret(String awsSecret) {
        this.awsSecret = awsSecret;
    }

    public String getAwsAccessKey() {
        return this.kerberosID;
    }

    public static S3SecretValue fromProtobuf(OzoneManagerProtocolProtos.S3Secret s3Secret) {
        return new S3SecretValue(s3Secret.getKerberosID(), s3Secret.getAwsSecret());
    }

    public OzoneManagerProtocolProtos.S3Secret getProtobuf() {
        return OzoneManagerProtocolProtos.S3Secret.newBuilder().setAwsSecret(this.awsSecret).setKerberosID(this.kerberosID).build();
    }

    public String toString() {
        return "awsAccessKey=" + this.kerberosID + "\nawsSecret=" + this.awsSecret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3SecretValue that = (S3SecretValue)o;
        return this.kerberosID.equals(that.kerberosID) && this.awsSecret.equals(that.awsSecret);
    }

    public int hashCode() {
        return Objects.hash(this.kerberosID, this.awsSecret);
    }
}

