/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.hadoop.ozone.recon.schema.ReconSchemaDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconSchemaManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconSchemaManager.class);
    private Set<ReconSchemaDefinition> reconSchemaDefinitions = new HashSet<ReconSchemaDefinition>();

    @Inject
    public ReconSchemaManager(Set<ReconSchemaDefinition> reconSchemaDefinitions) {
        this.reconSchemaDefinitions.addAll(reconSchemaDefinitions);
    }

    @VisibleForTesting
    public void createReconSchema() {
        this.reconSchemaDefinitions.forEach(reconSchemaDefinition -> {
            try {
                reconSchemaDefinition.initializeSchema();
            }
            catch (SQLException e) {
                LOG.error("Error creating Recon schema {}.", (Object)reconSchemaDefinition.getClass().getSimpleName(), (Object)e);
            }
        });
    }
}

