/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.recon.ReconConstants;
import org.apache.hadoop.ozone.recon.api.handlers.BucketHandler;
import org.apache.hadoop.ozone.recon.api.handlers.EntityHandler;
import org.apache.hadoop.ozone.recon.api.types.CountStats;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.api.types.FileSizeDistributionResponse;
import org.apache.hadoop.ozone.recon.api.types.NamespaceSummaryResponse;
import org.apache.hadoop.ozone.recon.api.types.QuotaUsageResponse;
import org.apache.hadoop.ozone.recon.api.types.ResponseStatus;
import org.apache.hadoop.ozone.recon.api.types.VolumeObjectDBInfo;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;

public class VolumeEntityHandler
extends EntityHandler {
    public VolumeEntityHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, String path) {
        super(reconNamespaceSummaryManager, omMetadataManager, reconSCM, null, path);
    }

    @Override
    public NamespaceSummaryResponse getSummaryResponse() throws IOException {
        String[] names = this.getNames();
        List<OmBucketInfo> buckets = this.getOmMetadataManager().listBucketsUnderVolume(names[0]);
        int totalDir = 0;
        long totalKey = 0L;
        for (OmBucketInfo bucket : buckets) {
            long bucketObjectId = bucket.getObjectID();
            totalDir += this.getTotalDirCount(bucketObjectId);
            totalKey += this.getTotalKeyCount(bucketObjectId);
        }
        CountStats countStats = new CountStats(-1, buckets.size(), totalDir, totalKey);
        return NamespaceSummaryResponse.newBuilder().setEntityType(EntityType.VOLUME).setCountStats(countStats).setObjectDBInfo(this.getVolumeObjDbInfo(names)).setStatus(ResponseStatus.OK).build();
    }

    private VolumeObjectDBInfo getVolumeObjDbInfo(String[] names) throws IOException {
        String dbVolumeKey = this.getOmMetadataManager().getVolumeKey(names[0]);
        if (null == dbVolumeKey) {
            return new VolumeObjectDBInfo();
        }
        OmVolumeArgs volumeArgs = (OmVolumeArgs)this.getOmMetadataManager().getVolumeTable().getSkipCache((Object)dbVolumeKey);
        if (null == volumeArgs) {
            return new VolumeObjectDBInfo();
        }
        return new VolumeObjectDBInfo(volumeArgs);
    }

    @Override
    public DUResponse getDuResponse(boolean listFile, boolean withReplica) throws IOException {
        DUResponse duResponse = new DUResponse();
        duResponse.setPath(this.getNormalizedPath());
        String[] names = this.getNames();
        String volName = names[0];
        List<OmBucketInfo> buckets = this.getOmMetadataManager().listBucketsUnderVolume(volName);
        duResponse.setCount(buckets.size());
        ArrayList<DUResponse.DiskUsage> bucketDuData = new ArrayList<DUResponse.DiskUsage>();
        long volDataSize = 0L;
        long volDataSizeWithReplica = 0L;
        for (OmBucketInfo bucket : buckets) {
            String bucketName = bucket.getBucketName();
            long bucketObjectID = bucket.getObjectID();
            String subpath = this.getOmMetadataManager().getBucketKey(volName, bucketName);
            DUResponse.DiskUsage diskUsage = new DUResponse.DiskUsage();
            diskUsage.setSubpath(subpath);
            long dataSize = this.getTotalSize(bucketObjectID);
            volDataSize += dataSize;
            if (withReplica) {
                BucketHandler bucketHandler = BucketHandler.getBucketHandler(this.getReconNamespaceSummaryManager(), this.getOmMetadataManager(), this.getReconSCM(), bucket);
                long bucketDU = bucketHandler.calculateDUUnderObject(bucketObjectID);
                diskUsage.setSizeWithReplica(bucketDU);
                volDataSizeWithReplica += bucketDU;
            }
            diskUsage.setSize(dataSize);
            bucketDuData.add(diskUsage);
        }
        if (withReplica) {
            duResponse.setSizeWithReplica(volDataSizeWithReplica);
        }
        duResponse.setSize(volDataSize);
        duResponse.setDuData(bucketDuData);
        return duResponse;
    }

    @Override
    public QuotaUsageResponse getQuotaResponse() throws IOException {
        QuotaUsageResponse quotaUsageResponse = new QuotaUsageResponse();
        String[] names = this.getNames();
        List<OmBucketInfo> buckets = this.getOmMetadataManager().listBucketsUnderVolume(names[0]);
        String volKey = this.getOmMetadataManager().getVolumeKey(names[0]);
        OmVolumeArgs volumeArgs = (OmVolumeArgs)this.getOmMetadataManager().getVolumeTable().getSkipCache((Object)volKey);
        long quotaInBytes = volumeArgs.getQuotaInBytes();
        long quotaUsedInBytes = 0L;
        for (OmBucketInfo bucketInfo : buckets) {
            long bucketObjectId = bucketInfo.getObjectID();
            quotaUsedInBytes += this.getTotalSize(bucketObjectId);
        }
        quotaUsageResponse.setQuota(quotaInBytes);
        quotaUsageResponse.setQuotaUsed(quotaUsedInBytes);
        return quotaUsageResponse;
    }

    @Override
    public FileSizeDistributionResponse getDistResponse() throws IOException {
        FileSizeDistributionResponse distResponse = new FileSizeDistributionResponse();
        String[] names = this.getNames();
        List<OmBucketInfo> buckets = this.getOmMetadataManager().listBucketsUnderVolume(names[0]);
        int[] volumeFileSizeDist = new int[ReconConstants.NUM_OF_FILE_SIZE_BINS];
        for (OmBucketInfo bucket : buckets) {
            long bucketObjectId = bucket.getObjectID();
            int[] bucketFileSizeDist = this.getTotalFileSizeDist(bucketObjectId);
            for (int i = 0; i < ReconConstants.NUM_OF_FILE_SIZE_BINS; ++i) {
                int n = i;
                volumeFileSizeDist[n] = volumeFileSizeDist[n] + bucketFileSizeDist[i];
            }
        }
        distResponse.setFileSizeDist(volumeFileSizeDist);
        return distResponse;
    }
}

