/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.recon.api.types.AclMetadata;
import org.apache.hadoop.ozone.recon.api.types.ObjectDBInfo;

public class KeyObjectDBInfo
extends ObjectDBInfo {
    @JsonProperty(value="volumeName")
    private String volumeName;
    @JsonProperty(value="bucketName")
    private String bucketName;
    @JsonProperty(value="keyName")
    private String keyName;
    @JsonProperty(value="dataSize")
    private long dataSize;
    @JsonProperty(value="keyLocationVersions")
    private List<OmKeyLocationInfoGroup> keyLocationVersions;
    @JsonProperty(value="replicationConfig")
    private ReplicationConfig replicationConfig;
    @JsonProperty(value="encInfo")
    private FileEncryptionInfo encInfo;
    private boolean isFile;
    private String fileName;

    public KeyObjectDBInfo() {
    }

    public KeyObjectDBInfo(OmKeyInfo omKeyInfo) {
        super.setName(omKeyInfo.getKeyName());
        super.setCreationTime(omKeyInfo.getCreationTime());
        super.setModificationTime(omKeyInfo.getModificationTime());
        super.setAcls(AclMetadata.fromOzoneAcls(omKeyInfo.getAcls()));
        super.setMetadata(omKeyInfo.getMetadata());
        this.setVolumeName(omKeyInfo.getVolumeName());
        this.setBucketName(omKeyInfo.getBucketName());
        this.setKeyName(omKeyInfo.getKeyName());
        this.setDataSize(omKeyInfo.getDataSize());
        this.setKeyLocationVersions(omKeyInfo.getKeyLocationVersions());
        this.setReplicationConfig(omKeyInfo.getReplicationConfig());
        this.setEncInfo(omKeyInfo.getFileEncryptionInfo());
        this.setFileName(omKeyInfo.getFileName());
        this.setFile(omKeyInfo.isFile());
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long dataSize) {
        this.dataSize = dataSize;
    }

    public List<OmKeyLocationInfoGroup> getKeyLocationVersions() {
        return this.keyLocationVersions;
    }

    public void setKeyLocationVersions(List<OmKeyLocationInfoGroup> keyLocationVersions) {
        this.keyLocationVersions = keyLocationVersions;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public void setReplicationConfig(ReplicationConfig replicationConfig) {
        this.replicationConfig = replicationConfig;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public void setFile(boolean file) {
        this.isFile = file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public FileEncryptionInfo getEncInfo() {
        return this.encInfo;
    }

    public void setEncInfo(FileEncryptionInfo encInfo) {
        this.encInfo = encInfo;
    }
}

