/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.fsck;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;

public class ContainerHealthStatus {
    private ContainerInfo container;
    private int replicaDelta;
    private Set<ContainerReplica> healthyReplicas;
    private ContainerPlacementStatus placementStatus;
    private ReconContainerMetadataManager reconContainerMetadataManager;
    private int numReplicas;
    private long numKeys;

    ContainerHealthStatus(ContainerInfo container, Set<ContainerReplica> healthyReplicas, PlacementPolicy placementPolicy, ReconContainerMetadataManager reconContainerMetadataManager) {
        this.reconContainerMetadataManager = reconContainerMetadataManager;
        this.container = container;
        int repFactor = container.getReplicationConfig().getRequiredNodes();
        this.healthyReplicas = healthyReplicas.stream().filter(r -> !r.getState().equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY)).collect(Collectors.toSet());
        this.replicaDelta = repFactor - this.healthyReplicas.size();
        this.placementStatus = this.getPlacementStatus(placementPolicy, repFactor);
        this.numReplicas = healthyReplicas.size();
        this.numKeys = this.getContainerKeyCount(container.getContainerID());
    }

    public long getContainerID() {
        return this.container.getContainerID();
    }

    public ContainerInfo getContainer() {
        return this.container;
    }

    public int getReplicationFactor() {
        return this.container.getReplicationConfig().getRequiredNodes();
    }

    public boolean isHealthy() {
        return this.replicaDelta == 0 && !this.isMisReplicated();
    }

    public boolean isDeleted() {
        return this.container.getState() == HddsProtos.LifeCycleState.DELETED || this.container.getState() == HddsProtos.LifeCycleState.DELETING;
    }

    public boolean isOverReplicated() {
        return this.replicaDelta < 0;
    }

    public boolean isUnderReplicated() {
        return !this.isMissing() && this.replicaDelta > 0;
    }

    public int replicaDelta() {
        return this.replicaDelta;
    }

    public int getReplicaCount() {
        return this.healthyReplicas.size();
    }

    public boolean isMisReplicated() {
        return !this.isMissing() && !this.placementStatus.isPolicySatisfied();
    }

    public int misReplicatedDelta() {
        return this.placementStatus.misReplicationCount();
    }

    public int expectedPlacementCount() {
        return this.placementStatus.expectedPlacementCount();
    }

    public int actualPlacementCount() {
        return this.placementStatus.actualPlacementCount();
    }

    public String misReplicatedReason() {
        return this.placementStatus.misReplicatedReason();
    }

    public boolean isMissing() {
        return this.numReplicas == 0;
    }

    public boolean isEmpty() {
        return this.numKeys == 0L;
    }

    private ContainerPlacementStatus getPlacementStatus(PlacementPolicy policy, int repFactor) {
        List dns = this.healthyReplicas.stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toList());
        return policy.validateContainerPlacement(dns, repFactor);
    }

    private long getContainerKeyCount(long containerID) {
        try {
            return this.reconContainerMetadataManager.getKeyCountForContainer(containerID);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getNumKeys() {
        return this.numKeys;
    }
}

