/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.metrics;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeFloat;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@Metrics(about="Recon OzoneManagerSync Metrics", context="ozone")
public final class OzoneManagerSyncMetrics {
    private static final String SOURCE_NAME = OzoneManagerSyncMetrics.class.getSimpleName();
    @Metric(about="Number of OM snapshot requests made by Recon.")
    private MutableCounterLong numSnapshotRequests;
    @Metric(about="Number of OM snapshot requests that failed.")
    private MutableCounterLong numSnapshotRequestsFailed;
    @Metric(about="OM snapshot request latency")
    private MutableRate snapshotRequestLatency;
    @Metric(about="Number of OM delta requests made by Recon that had at least 1 update in the response.")
    private MutableCounterLong numNonZeroDeltaRequests;
    @Metric(about="Number of OM delta requests that failed.")
    private MutableCounterLong numDeltaRequestsFailed;
    @Metric(about="Total number of updates got through OM delta request")
    private MutableCounterLong numUpdatesInDeltaTotal;
    @Metric(about="Average number of updates got per OM delta request")
    private MutableGaugeFloat averageNumUpdatesInDeltaRequest;
    @Metric(about="The lag of sequence number between Recon and OM")
    private MutableGaugeLong sequenceNumberLag;

    private OzoneManagerSyncMetrics() {
    }

    public static OzoneManagerSyncMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (OzoneManagerSyncMetrics)ms.register(SOURCE_NAME, "Recon Ozone Manager Sync Metrics", (Object)new OzoneManagerSyncMetrics());
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void incrNumSnapshotRequests() {
        this.numSnapshotRequests.incr();
    }

    public void incrNumSnapshotRequestsFailed() {
        this.numSnapshotRequestsFailed.incr();
    }

    public void updateSnapshotRequestLatency(long time) {
        this.snapshotRequestLatency.add(time);
    }

    public void incrNumDeltaRequestsFailed() {
        this.numSnapshotRequestsFailed.incr();
    }

    public void incrNumUpdatesInDeltaTotal(long n) {
        this.numUpdatesInDeltaTotal.incr(n);
        this.numNonZeroDeltaRequests.incr();
        this.setAverageNumUpdatesInDeltaRequest((float)this.numUpdatesInDeltaTotal.value() / (float)this.numNonZeroDeltaRequests.value());
    }

    public void setAverageNumUpdatesInDeltaRequest(float avg) {
        this.averageNumUpdatesInDeltaRequest.set(avg);
    }

    public MutableCounterLong getNumSnapshotRequests() {
        return this.numSnapshotRequests;
    }

    public MutableCounterLong getNumSnapshotRequestsFailed() {
        return this.numSnapshotRequestsFailed;
    }

    public MutableRate getSnapshotRequestLatency() {
        return this.snapshotRequestLatency;
    }

    public MutableCounterLong getNumDeltaRequestsFailed() {
        return this.numDeltaRequestsFailed;
    }

    public MutableCounterLong getNumUpdatesInDeltaTotal() {
        return this.numUpdatesInDeltaTotal;
    }

    public MutableGaugeFloat getAverageNumUpdatesInDeltaRequest() {
        return this.averageNumUpdatesInDeltaRequest;
    }

    public MutableCounterLong getNumNonZeroDeltaRequests() {
        return this.numNonZeroDeltaRequests;
    }

    public void setSequenceNumberLag(long lag) {
        this.sequenceNumberLag.set(lag);
    }

    public MutableGaugeLong getSequenceNumberLag() {
        return this.sequenceNumberLag;
    }
}

