/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.recon.api.types.KeyPrefixContainer;

public final class KeyPrefixContainerCodec
implements Codec<KeyPrefixContainer> {
    private static final Codec<KeyPrefixContainer> INSTANCE = new KeyPrefixContainerCodec();
    private static final String KEY_DELIMITER = "_";

    public static Codec<KeyPrefixContainer> get() {
        return INSTANCE;
    }

    private KeyPrefixContainerCodec() {
    }

    public byte[] toPersistedFormat(KeyPrefixContainer keyPrefixContainer) throws IOException {
        Preconditions.checkNotNull((Object)keyPrefixContainer, (Object)"Null object can't be converted to byte array.");
        byte[] keyPrefixBytes = keyPrefixContainer.getKeyPrefix().getBytes("UTF-8");
        if (keyPrefixContainer.getKeyVersion() != -1L) {
            keyPrefixBytes = ArrayUtils.addAll((byte[])keyPrefixBytes, (byte[])KEY_DELIMITER.getBytes("UTF-8"));
            keyPrefixBytes = ArrayUtils.addAll((byte[])keyPrefixBytes, (byte[])Longs.toByteArray((long)keyPrefixContainer.getKeyVersion()));
        }
        if (keyPrefixContainer.getContainerId() != -1L) {
            keyPrefixBytes = ArrayUtils.addAll((byte[])keyPrefixBytes, (byte[])KEY_DELIMITER.getBytes("UTF-8"));
            keyPrefixBytes = ArrayUtils.addAll((byte[])keyPrefixBytes, (byte[])Longs.toByteArray((long)keyPrefixContainer.getContainerId()));
        }
        return keyPrefixBytes;
    }

    public KeyPrefixContainer fromPersistedFormat(byte[] rawData) throws IOException {
        byte[] keyBytes = ArrayUtils.subarray((byte[])rawData, (int)0, (int)(rawData.length - 16 - 2));
        String keyPrefix = new String(keyBytes, "UTF-8");
        byte[] versionBytes = ArrayUtils.subarray((byte[])rawData, (int)(rawData.length - 16 - 1), (int)(rawData.length - 8 - 1));
        long version = ByteBuffer.wrap(versionBytes).getLong();
        long containerIdFromDB = ByteBuffer.wrap(ArrayUtils.subarray((byte[])rawData, (int)(rawData.length - 8), (int)rawData.length)).getLong();
        return KeyPrefixContainer.get(keyPrefix, version, containerIdFromDB);
    }

    public KeyPrefixContainer copyObject(KeyPrefixContainer object) {
        return object;
    }
}

