/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskDbEventHandler;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSummaryTaskWithLegacy
extends NSSummaryTaskDbEventHandler {
    private static final BucketLayout BUCKET_LAYOUT = BucketLayout.LEGACY;
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryTaskWithLegacy.class);
    private boolean enableFileSystemPaths;

    public NSSummaryTaskWithLegacy(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager reconOMMetadataManager, OzoneConfiguration ozoneConfiguration) {
        super(reconNamespaceSummaryManager, reconOMMetadataManager, ozoneConfiguration);
        this.enableFileSystemPaths = ozoneConfiguration.getBoolean("ozone.om.enable.filesystem.paths", false);
    }

    public boolean processWithLegacy(OMUpdateEventBatch events) {
        Iterator<OMDBUpdateEvent> eventIterator = events.getIterator();
        HashMap<Long, NSSummary> nsSummaryMap = new HashMap<Long, NSSummary>();
        while (eventIterator.hasNext()) {
            OMDBUpdateEvent omdbUpdateEvent = eventIterator.next();
            OMDBUpdateEvent.OMDBUpdateAction action = omdbUpdateEvent.getAction();
            String table = omdbUpdateEvent.getTable();
            boolean updateOnKeyTable = table.equals("keyTable");
            if (!updateOnKeyTable) continue;
            String updatedKey = (String)omdbUpdateEvent.getKey();
            try {
                OMDBUpdateEvent keyTableUpdateEvent = omdbUpdateEvent;
                Object value = keyTableUpdateEvent.getValue();
                Object oldValue = keyTableUpdateEvent.getOldValue();
                if (!(value instanceof OmKeyInfo)) {
                    LOG.warn("Unexpected value type {} for key {}. Skipping processing.", (Object)value.getClass().getName(), (Object)updatedKey);
                    continue;
                }
                OmKeyInfo updatedKeyInfo = (OmKeyInfo)value;
                OmKeyInfo oldKeyInfo = (OmKeyInfo)oldValue;
                String volumeName = updatedKeyInfo.getVolumeName();
                String bucketName = updatedKeyInfo.getBucketName();
                String bucketDBKey = this.getReconOMMetadataManager().getBucketKey(volumeName, bucketName);
                OmBucketInfo omBucketInfo = (OmBucketInfo)this.getReconOMMetadataManager().getBucketTable().getSkipCache((Object)bucketDBKey);
                if (omBucketInfo.getBucketLayout().isObjectStore(this.enableFileSystemPaths)) continue;
                this.setKeyParentID(updatedKeyInfo);
                if (!updatedKeyInfo.getKeyName().endsWith("/")) {
                    switch (action) {
                        case PUT: {
                            this.handlePutKeyEvent(updatedKeyInfo, nsSummaryMap);
                            break;
                        }
                        case DELETE: {
                            this.handleDeleteKeyEvent(updatedKeyInfo, nsSummaryMap);
                            break;
                        }
                        case UPDATE: {
                            if (oldKeyInfo != null) {
                                this.setKeyParentID(oldKeyInfo);
                                this.handleDeleteKeyEvent(oldKeyInfo, nsSummaryMap);
                            } else {
                                LOG.warn("Update event does not have the old keyInfo for {}.", (Object)updatedKey);
                            }
                            this.handlePutKeyEvent(updatedKeyInfo, nsSummaryMap);
                            break;
                        }
                        default: {
                            LOG.debug("Skipping DB update event : {}", (Object)omdbUpdateEvent.getAction());
                            break;
                        }
                    }
                } else {
                    OmDirectoryInfo updatedDirectoryInfo = new OmDirectoryInfo.Builder().setName(updatedKeyInfo.getKeyName()).setObjectID(updatedKeyInfo.getObjectID()).setParentObjectID(updatedKeyInfo.getParentObjectID()).build();
                    OmDirectoryInfo oldDirectoryInfo = null;
                    if (oldKeyInfo != null) {
                        oldDirectoryInfo = new OmDirectoryInfo.Builder().setName(oldKeyInfo.getKeyName()).setObjectID(oldKeyInfo.getObjectID()).setParentObjectID(oldKeyInfo.getParentObjectID()).build();
                    }
                    switch (action) {
                        case PUT: {
                            this.handlePutDirEvent(updatedDirectoryInfo, nsSummaryMap);
                            break;
                        }
                        case DELETE: {
                            this.handleDeleteDirEvent(updatedDirectoryInfo, nsSummaryMap);
                            break;
                        }
                        case UPDATE: {
                            if (oldDirectoryInfo != null) {
                                this.handleDeleteDirEvent(oldDirectoryInfo, nsSummaryMap);
                            } else {
                                LOG.warn("Update event does not have the old dirInfo for {}.", (Object)updatedKey);
                            }
                            this.handlePutDirEvent(updatedDirectoryInfo, nsSummaryMap);
                            break;
                        }
                        default: {
                            LOG.debug("Skipping DB update event : {}", (Object)omdbUpdateEvent.getAction());
                        }
                    }
                }
            }
            catch (IOException ioEx) {
                LOG.error("Unable to process Namespace Summary data in Recon DB. ", (Throwable)ioEx);
                return false;
            }
            if (this.checkAndCallFlushToDB(nsSummaryMap)) continue;
            return false;
        }
        if (!this.flushAndCommitNSToDB(nsSummaryMap)) {
            return false;
        }
        LOG.info("Completed a process run of NSSummaryTaskWithLegacy");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reprocessWithLegacy(OMMetadataManager omMetadataManager) {
        HashMap<Long, NSSummary> nsSummaryMap = new HashMap<Long, NSSummary>();
        try {
            Table keyTable = omMetadataManager.getKeyTable(BUCKET_LAYOUT);
            try (TableIterator keyTableIter = keyTable.iterator();){
                while (keyTableIter.hasNext()) {
                    Table.KeyValue kv = (Table.KeyValue)keyTableIter.next();
                    OmKeyInfo keyInfo = (OmKeyInfo)kv.getValue();
                    String volumeName = keyInfo.getVolumeName();
                    String bucketName = keyInfo.getBucketName();
                    String bucketDBKey = omMetadataManager.getBucketKey(volumeName, bucketName);
                    OmBucketInfo omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().getSkipCache((Object)bucketDBKey);
                    if (omBucketInfo.getBucketLayout().isObjectStore(this.enableFileSystemPaths)) continue;
                    this.setKeyParentID(keyInfo);
                    if (keyInfo.getKeyName().endsWith("/")) {
                        OmDirectoryInfo directoryInfo = new OmDirectoryInfo.Builder().setName(keyInfo.getKeyName()).setObjectID(keyInfo.getObjectID()).setParentObjectID(keyInfo.getParentObjectID()).build();
                        this.handlePutDirEvent(directoryInfo, nsSummaryMap);
                    } else {
                        this.handlePutKeyEvent(keyInfo, nsSummaryMap);
                    }
                    if (this.checkAndCallFlushToDB(nsSummaryMap)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (IOException ioEx) {
            LOG.error("Unable to reprocess Namespace Summary data in Recon DB. ", (Throwable)ioEx);
            return false;
        }
        if (!this.flushAndCommitNSToDB(nsSummaryMap)) {
            return false;
        }
        LOG.info("Completed a reprocess run of NSSummaryTaskWithLegacy");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setKeyParentID(OmKeyInfo keyInfo) throws IOException {
        String[] keyPath = keyInfo.getKeyName().split("/");
        if (keyPath.length > 1) {
            CharSequence[] dirs = Arrays.copyOf(keyPath, keyPath.length - 1);
            String parentKeyName = String.join((CharSequence)"/", dirs);
            parentKeyName = parentKeyName + "/";
            String fullParentKeyName = this.getReconOMMetadataManager().getOzoneKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), parentKeyName);
            OmKeyInfo parentKeyInfo = (OmKeyInfo)this.getReconOMMetadataManager().getKeyTable(BUCKET_LAYOUT).getSkipCache((Object)fullParentKeyName);
            if (parentKeyInfo == null) throw new IOException("ParentKeyInfo for NSSummaryTaskWithLegacy is null");
            keyInfo.setParentObjectID(parentKeyInfo.getObjectID());
            return;
        } else {
            String bucketKey = this.getReconOMMetadataManager().getBucketKey(keyInfo.getVolumeName(), keyInfo.getBucketName());
            OmBucketInfo parentBucketInfo = (OmBucketInfo)this.getReconOMMetadataManager().getBucketTable().getSkipCache((Object)bucketKey);
            if (parentBucketInfo == null) throw new IOException("ParentKeyInfo for NSSummaryTaskWithLegacy is null");
            keyInfo.setParentObjectID(parentBucketInfo.getObjectID());
        }
    }
}

