/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.nssummary;

import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.admin.nssummary.NSSummaryAdmin;
import org.apache.hadoop.ozone.admin.nssummary.NSSummaryCLIUtils;
import org.apache.hadoop.ozone.shell.ListOptions;
import picocli.CommandLine;

@CommandLine.Command(name="du", description={"Get disk usage for a path request."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class DiskUsageSubCommand
implements Callable {
    @CommandLine.ParentCommand
    private NSSummaryAdmin parent;
    @CommandLine.Parameters(index="0", arity="0..1", description={"Non-empty path request without any protocol prefix."})
    private String path;
    @CommandLine.Option(names={"-f", "--file"}, description={"List direct files as a sub path."})
    private boolean listFiles;
    @CommandLine.Option(names={"-r", "--replica"}, description={"Show disk usage with replication."})
    private boolean withReplica;
    @CommandLine.Option(names={"-n", "--no-header"}, description={"Show DU without the header for current path."})
    private boolean noHeader;
    @CommandLine.Mixin
    private ListOptions listOptions;
    private static final String ENDPOINT = "/api/v1/namespace/du";
    private static final String SIZE_HEADER = "Size";
    private static final String DU_HEADER = "Disk Usage";
    private static final String PATH_HEADER = "Path Name";
    private static final int SIZE_INDENT = 2;
    private static final int DU_INDENT = 12;
    private static final int PATH_INDENT = 27;
    private StringBuffer url = new StringBuffer();

    public Void call() throws Exception {
        block10: {
            HashMap<String, Object> duResponse;
            block11: {
                block12: {
                    block9: {
                        if (this.path == null || this.path.length() == 0) {
                            NSSummaryCLIUtils.printEmptyPathRequest();
                            return null;
                        }
                        this.url.append(this.parent.getReconWebAddress()).append(ENDPOINT);
                        String response = NSSummaryCLIUtils.makeHttpCall(this.url, NSSummaryCLIUtils.parseInputPath(this.path), this.listFiles, this.withReplica, this.parent.isHTTPSEnabled(), this.parent.getOzoneConfig());
                        NSSummaryCLIUtils.printNewLines(1);
                        if (response == null) {
                            NSSummaryCLIUtils.printNewLines(1);
                            return null;
                        }
                        duResponse = NSSummaryCLIUtils.getResponseMap(response);
                        if (!duResponse.get("status").equals("PATH_NOT_FOUND")) break block9;
                        NSSummaryCLIUtils.printPathNotFound();
                        break block10;
                    }
                    if (this.parent.isObjectStoreBucket(this.path) || !this.parent.bucketIsPresentInThePath(this.path)) {
                        NSSummaryCLIUtils.printBucketReminder();
                    }
                    long totalSize = (long)((Double)duResponse.get("size")).doubleValue();
                    if (!this.noHeader) {
                        NSSummaryCLIUtils.printWithUnderline("Path", false);
                        NSSummaryCLIUtils.printKVSeparator();
                        System.out.println(duResponse.get("path"));
                        NSSummaryCLIUtils.printWithUnderline("Total Size", false);
                        NSSummaryCLIUtils.printKVSeparator();
                        System.out.println(FileUtils.byteCountToDisplaySize((long)totalSize));
                        if (this.withReplica) {
                            NSSummaryCLIUtils.printWithUnderline("Total Disk Usage", false);
                            NSSummaryCLIUtils.printKVSeparator();
                            long du = (long)((Double)duResponse.get("sizeWithReplica")).doubleValue();
                            System.out.println(FileUtils.byteCountToDisplaySize((long)du));
                        }
                        long sizeDirectKey = (long)((Double)duResponse.get("sizeDirectKey")).doubleValue();
                        if (!this.listFiles && sizeDirectKey != -1L) {
                            NSSummaryCLIUtils.printWithUnderline("Size of Direct Keys", false);
                            NSSummaryCLIUtils.printKVSeparator();
                            System.out.println(FileUtils.byteCountToDisplaySize((long)sizeDirectKey));
                        }
                        NSSummaryCLIUtils.printNewLines(1);
                    }
                    if ((Double)duResponse.get("subPathCount") != 0.0) break block11;
                    if (totalSize != 0L) break block12;
                    System.out.println("The object is empty.\nPut more files into it to visualize DU");
                    break block10;
                }
                System.out.println("There's no immediate sub-path under this object.");
                if (this.listFiles) break block10;
                System.out.println("Add -f as an option to visualize files as sub-path, if any.");
                break block10;
            }
            NSSummaryCLIUtils.printWithUnderline("DU", true);
            this.printDUHeader();
            int limit = this.listOptions.getLimit();
            String seekStr = this.listOptions.getPrefix();
            if (seekStr == null) {
                seekStr = "";
            }
            ArrayList duData = (ArrayList)duResponse.get("subPaths");
            int cnt = 0;
            for (int i = 0; i < duData.size() && cnt < limit; ++i) {
                LinkedTreeMap subPathDU = (LinkedTreeMap)duData.get(i);
                String subPath = subPathDU.get((Object)"path").toString();
                if (!((Boolean)subPathDU.get((Object)"isKey")).booleanValue()) {
                    subPath = subPath + "/";
                }
                long size = (long)((Double)subPathDU.get((Object)"size")).doubleValue();
                long sizeWithReplica = (long)((Double)subPathDU.get((Object)"sizeWithReplica")).doubleValue();
                if (!subPath.startsWith(seekStr)) continue;
                this.printDURow(subPath, size, sizeWithReplica);
                ++cnt;
            }
        }
        NSSummaryCLIUtils.printNewLines(1);
        return null;
    }

    private void printDUHeader() {
        NSSummaryCLIUtils.printSpaces(2);
        System.out.print(SIZE_HEADER);
        NSSummaryCLIUtils.printSpaces(10 - SIZE_HEADER.length());
        if (this.withReplica) {
            System.out.print(DU_HEADER);
            NSSummaryCLIUtils.printSpaces(15 - DU_HEADER.length());
            System.out.println(PATH_HEADER);
        } else {
            System.out.println(PATH_HEADER);
        }
    }

    private void printDURow(String subPath, long size, long sizeWithReplica) {
        NSSummaryCLIUtils.printSpaces(2);
        String dataSize = FileUtils.byteCountToDisplaySize((long)size);
        System.out.print(dataSize);
        NSSummaryCLIUtils.printSpaces(10 - dataSize.length());
        if (sizeWithReplica != -1L) {
            String dataSizeWithReplica = FileUtils.byteCountToDisplaySize((long)sizeWithReplica);
            System.out.print(dataSizeWithReplica);
            NSSummaryCLIUtils.printSpaces(15 - dataSizeWithReplica.length());
        }
        System.out.println(subPath);
    }
}

