/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.nssummary;

import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.admin.nssummary.NSSummaryAdmin;
import org.apache.hadoop.ozone.admin.nssummary.NSSummaryCLIUtils;
import picocli.CommandLine;

@CommandLine.Command(name="summary", description={"Get entity type and object counts for a path request."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class SummarySubCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private NSSummaryAdmin parent;
    @CommandLine.Parameters(index="0", arity="0..1", description={"Non-empty path request without any protocol prefix."})
    private String path;
    private static final String ENDPOINT = "/api/v1/namespace/summary";
    private StringBuffer url = new StringBuffer();

    @Override
    public Void call() throws Exception {
        if (this.path == null || this.path.length() == 0) {
            NSSummaryCLIUtils.printEmptyPathRequest();
            return null;
        }
        this.url.append(this.parent.getReconWebAddress()).append(ENDPOINT);
        NSSummaryCLIUtils.printNewLines(1);
        String response = NSSummaryCLIUtils.makeHttpCall(this.url, NSSummaryCLIUtils.parseInputPath(this.path), this.parent.isHTTPSEnabled(), this.parent.getOzoneConfig());
        if (response == null) {
            NSSummaryCLIUtils.printNewLines(1);
            return null;
        }
        HashMap<String, Object> summaryResponse = NSSummaryCLIUtils.getResponseMap(response);
        if (summaryResponse.get("status").equals("PATH_NOT_FOUND")) {
            NSSummaryCLIUtils.printPathNotFound();
        } else {
            if (this.parent.isObjectStoreBucket(this.path) || !this.parent.bucketIsPresentInThePath(this.path)) {
                NSSummaryCLIUtils.printBucketReminder();
            }
            NSSummaryCLIUtils.printWithUnderline("Entity Type", false);
            NSSummaryCLIUtils.printKVSeparator();
            System.out.println(summaryResponse.get("type"));
            int numVol = ((Double)summaryResponse.get("numVolume")).intValue();
            int numBucket = ((Double)summaryResponse.get("numBucket")).intValue();
            int numDir = ((Double)summaryResponse.get("numDir")).intValue();
            int numKey = ((Double)summaryResponse.get("numKey")).intValue();
            if (numVol != -1) {
                NSSummaryCLIUtils.printWithUnderline("Volumes", false);
                NSSummaryCLIUtils.printKVSeparator();
                System.out.println(numVol);
            }
            if (numBucket != -1) {
                NSSummaryCLIUtils.printWithUnderline("Buckets", false);
                NSSummaryCLIUtils.printKVSeparator();
                System.out.println(numBucket);
            }
            if (numDir != -1) {
                NSSummaryCLIUtils.printWithUnderline("Directories", false);
                NSSummaryCLIUtils.printKVSeparator();
                System.out.println(numDir);
            }
            if (numKey != -1) {
                NSSummaryCLIUtils.printWithUnderline("Keys", false);
                NSSummaryCLIUtils.printKVSeparator();
                System.out.println(numKey);
            }
        }
        NSSummaryCLIUtils.printNewLines(1);
        return null;
    }
}

